% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-plots-method.R
\name{plotDSGEx}
\alias{plotDSGEx}
\title{plotDSGEx Generic}
\usage{
plotDSGEx(object)
}
\arguments{
\item{object}{CoSIAn object with all user accessible slots filled in as well
as the converted_id and metric slot filled}
}
\value{
initializes a generic function for plotDSGEx as preparation for
defining the plotDSGEx Method
}
\description{
plotDSGEx Generic
}
\examples{
Kidney_Genes <- CoSIAn(
    gene_set = c("ENSG00000008710", "ENSG00000118762", "ENSG00000152217"),
    i_species = "h_sapiens", input_id = "Ensembl_id", o_species = c(
        "d_melanogaster", "m_musculus",
        "h_sapiens", "d_rerio", "c_elegans", "r_norvegicus"
    ), output_ids = c("Ensembl_id", "Symbol"),
    mapping_tool = "annotationDBI", ortholog_database = "HomoloGene",
    map_tissues = "heart", map_species = c("m_musculus"),
    metric_type = "DS_Gene"
)
Kidney_gene_conversion <- CoSIA::getConversion(Kidney_Genes)
Kidney_gene_metric <- getGExMetrics(Kidney_gene_conversion)
plotDSGEx(Kidney_gene_metric)
}
