% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCompDbPackage.R
\name{import_mona_sdf}
\alias{import_mona_sdf}
\title{Import compound and spectrum information from MoNa}
\usage{
import_mona_sdf(x, nonStop = TRUE)
}
\arguments{
\item{x}{\code{character(1)} being the SDF file name.}

\item{nonStop}{\code{logical(1)} whether file content specific errors should
only reported as warnings and not break the full import process. The
value of this parameter is passed to parameter \code{skipErrors} of the
\code{\link[ChemmineR:read.SDFset]{ChemmineR::read.SDFset()}} function.}
}
\value{
A \code{list} with elements \code{"compound"} and \code{"msms_spectrum"} containing
data.frames with compound and MS/MS spectrum data, respectively.
}
\description{
\code{import_mona_sdf()} allows to import compound and spectrum information from
an SDF file from MoNa (Massbank of North America
http://mona.fiehnlab.ucdavis.edu/). This function is a convenience function
using the \code{\link[=compound_tbl_sdf]{compound_tbl_sdf()}} and \code{\link[=msms_spectra_mona]{msms_spectra_mona()}} functions for data
import but avoiding to read the SDF files twice.
}
\note{
MoNa SDF files organize the data by individual spectra (i.e. each element
is one spectrum) and individual compounds can not easily and consistently
defined (i.e. not all entries have an InChI ID or other means to uniquely
identify compounds). Thus, the function returns a highly redundant compound
table. Feedback on how to reduce this redundancy would be highly welcome!
}
\examples{

## Define the test file containing a small subset from MoNa
fl <- system.file("sdf/MoNa_export-All_Spectra_sub.sdf.gz",
    package = "CompoundDb")

## Import the data
res <- import_mona_sdf(fl)
}
\seealso{
\code{\link[=compound_tbl_sdf]{compound_tbl_sdf()}} to read only the compound information.

\code{\link[=msms_spectra_mona]{msms_spectra_mona()}} to read only the spectrum data.
}
\author{
Johannes Rainer
}
