% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getColumn}
\alias{getColumn}
\title{getColumn}
\usage{
getColumn(df, col=NULL, pattern="", avoid.pattern = NULL, msg.col.name="", needed=TRUE, verbose = TRUE)
}
\arguments{
\item{df}{(data.frame or equivalent) The object were columns are searched. It must be either a data.frame or an object where names(df) works.}

\item{col}{(number or character) The column to identify. If NULL an heuristic will be used to automatically identify the column. It can also a number or a character to define the exact column to return.(defaults to NULL)}

\item{pattern}{(character) The pattern to match the column name. If more than one column matches the pattern, the first one (leftmost) will be returned. The pattern may be any valid regular expression. (defaults to "")}

\item{avoid.pattern}{(character) The pattern to avoid on the column name. The pattern may be any valid regular expression. (defaults to "")}

\item{msg.col.name}{(character) Only used in the error message to make the message clearer. The name of the column we are searching for. (defaults to "")}

\item{needed}{(logical) Whether the column is needed or not. If TRUE, an error will be raised if the column is not found. (defaults to TRUE)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
The number of the column matching the specification or NULL if no column was found.
}
\description{
Use simple pattern matching to try to identify a column in a data.frame or
equivalent by its name
}
\details{
This function will use pattern matching to try to identify which column of
a data.frame contains a certain data. It will return its number. If
\code{col} is specified it will not use pattern matching but identify
if a column with that exact name exists and return its position.
}
\examples{

df <- data.frame("id"= "rs1234", "endogenous" = FALSE, "chromosome"="chr1", "Start"=0, "end.position"=100,
"copy.number.level"=3, "LOH"=0, "median.value.per.segment"=1.2,
"BAF"=0.2, "Log Ratio"=1.5,  "strange.name"="strange.value")

col.num <- getColumn(df = df, pattern = "Chr|chr",  msg.col.name = "Chromosome", needed = TRUE)
col.num <- getColumn(df = df, col = "chromosome",  msg.col.name = "Chromosome", needed = TRUE)
col.num <- getColumn(df = df, col = 3, msg.col.name = "Chromosome", needed = TRUE)


col.num <- getColumn(df = df, pattern = "end",  msg.col.name = "End", needed = TRUE)
col.num <- getColumn(df = df, pattern = "end", avoid.pattern = "endogenous", msg.col.name = "End", needed = TRUE)

}
