% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleCellCopyNumberCalls.R
\name{plotSingleCellCopyNumberCalls}
\alias{plotSingleCellCopyNumberCalls}
\title{plotSingleCellCopyNumberCalls}
\usage{
plotSingleCellCopyNumberCalls(karyoplot, cnv.file, reorder=TRUE, cn.colors=NULL, track.margin=0, r0=0, r1=1, ...)
}
\arguments{
\item{karyoplot}{A karyoplote object}

\item{cnv.file}{(an HDF5 file) The path to an HDF5 file containing the single-cell CNV data.}

\item{reorder}{(logical) If TRUE, the cells will be plotted inthe order specified by the hirearchical clustering tree embedded in the HDF5 file. If FALSE the cells will be plotted in the order they are stored in the file. (defaukts to TRUE)}

\item{cn.colors}{(colors) The colors assigned to gains and losses. \code{\link{getCopyNumberColors}} is used to determine them. If NULL, the default color scheme is used. (defaults to NULL)}

\item{track.margin}{(numeric) This is the margin between the cells CN, in portion of the total per cell space. (deafults to 0)}

\item{r0}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)(defaults to 0)}

\item{r1}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)(defaults to 1)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to karyoploteR functions.}
}
\value{
Invisibly returns the karyoplot object representing the plot. With it
it is possible to add other elements to the plot using standrad karyoploteR
functions. The returned pbject will have an additional "latest.plot" 
element with a list containing: the number of cells, the hierarchical 
clustering tree, the bin size used to partition the genome, the windows
representing such partitioning, the number of bins per chromosome and a
GRAnges with the regions where no cell had any data, the no-call regions.
}
\description{
Plot the segments representing the copy number calls from a single-cell
CNV data file. The file must be an HDF5 file with the same format as the
ones produced by 10X CellRanger software.
}
\details{
This function will open the HDF5 file, extract the CNV values for each 
cell and plot them as a different colored segments using 
\code{\link{plotCopyNumberCalls}}. 
By default cells will be reordered and plotted according the hierarchical 
clustering tree embedded in the file. If reorder is FALSE or the tree is
not present, cell will be plotted in the order they are stored in the file.
}
\note{
If the file is open by any other application the function will fail.
}
\examples{

kp <- plotKaryotype(plot.type=4, genome="hg38")
#NOT RUN - Using 10X example data from https://www.10xgenomics.com/resources/datasets/
#plotSingleCellCopyNumberCalls(kp, "breast_tissue_D_2k_cnv_data.h5")


}
