% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{FindClusterBatchKNN}
\alias{FindClusterBatchKNN}
\title{Find batch k nearest neighbors per cluster}
\usage{
FindClusterBatchKNN(preds, probs, batch, k = 10, k.prop = NULL)
}
\arguments{
\item{preds}{A numeric vector with the cell cluster predictions.}

\item{probs}{A numeric matrix with cell cluster probabilities.}

\item{batch}{A character with batch labels.}

\item{k}{The number of nearest neighbors to search for. Default is \code{10}.}

\item{k.prop}{A numeric (higher than 0 and lower than 1) corresponding to the
fraction of cells per cluster to use as \code{k} nearest neighbors. Default
is \code{NULL} meaning that the number of \code{k} nearest neighbors is equal
to \code{k}. If given, \code{k} parameter is ignored and \code{k} is calculated
based on \code{k.prop}.}
}
\value{
a list containing the k nearest neighbors for every cluster
}
\description{
The function finds batch k nearest neighbors for the cell with the highest
probability for every batch per cluster.
}
\keyword{internal}
