% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-optimization.R
\name{drop_fn_params}
\alias{drop_fn_params}
\title{Drop parameters from a function and replace them with constants
inside the function body.}
\usage{
drop_fn_params(fn, args)
}
\arguments{
\item{fn}{\code{function} A non-primitive function to remove parameters from
(via \code{base::formals(fn)}).}

\item{args}{\code{list} A list where names are the function arguments (parameters)
to remove and the values are the appopriate value to replace the parameter
with in the function body.}
}
\value{
\code{function} A new non-primitize function with the parameters named in
\code{args} deleted and their values fixed with the values from \code{args} in the
function body.
}
\description{
Drop parameters from a function and replace them with constants
inside the function body.
}
