% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplots.R
\name{ggplotDistFeatureImportance}
\alias{ggplotDistFeatureImportance}
\title{Plot of feature relative importance in distance}
\usage{
ggplotDistFeatureImportance(distObj)
}
\arguments{
\item{distObj}{a DistSum object.}
}
\value{
a ggplot object
}
\description{
\code{ggplotDistFeatureImportance} uses ggplot2
to provide a stacked bar plot of feature importance in a distance matrix.
}
\examples{

library(CytoPipeline)

data(OMIP021Samples)

# estimate scale transformations 
# and transform the whole OMIP021Samples

transList <- estimateScaleTransforms(
    ff = OMIP021Samples[[1]],
    fluoMethod = "estimateLogicle",
    scatterMethod = "linearQuantile",
    scatterRefMarker = "BV785 - CD3")

OMIP021Trans <- CytoPipeline::applyScaleTransforms(
    OMIP021Samples, 
    transList)

# As there are only 2 samples in OMIP021Samples dataset,
# we create artificial samples that are random combinations of both samples

ffList <- c(
    flowCore::flowSet_to_list(OMIP021Trans),
    lapply(3:5,
           FUN = function(i) {
               aggregateAndSample(
                   OMIP021Trans,
                   seed = 10*i,
                   nTotalEvents = 5000)[,1:22]
           }))

fsNames <- c("Donor1", "Donor2", paste0("Agg",1:3))
names(ffList) <- fsNames

fsAll <- as(ffList,"flowSet")

flowCore::pData(fsAll)$type <- factor(c("real", "real", rep("synthetic", 3)))
flowCore::pData(fsAll)$grpId <- factor(c("D1", "D2", rep("Agg", 3)))

# calculate all pairwise distances

pwDist <- pairwiseEMDDist(fsAll, 
                             channels = c("FSC-A", "SSC-A"),
                             verbose = FALSE)
                             
p <- ggplotDistFeatureImportance(pwDist)
                             
}
\seealso{
\link{pairwiseEMDDist}
}
