% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet2flowJo.R
\name{gatingset_to_flowjo}
\alias{gatingset_to_flowjo}
\alias{GatingSet2flowJo}
\title{Convert a GatingSet to flowJo workspace}
\usage{
gatingset_to_flowjo(gs, outFile, showHidden = FALSE, docker_img = NULL, ...)
}
\arguments{
\item{gs}{a GatingSet object or a folder contains the GatingSet archive (generated by previous \code{\link{save_gs}} call)}

\item{outFile}{the workspace file path to write}

\item{showHidden}{whether to export hidden gates. Default is FALSE}

\item{docker_img}{the docker image that does the actual work}

\item{...}{other arguments passed to \code{\link{save_gs}}}
}
\value{
nothing
}
\description{
It is a R wrapper for the docker app
(https://hub.docker.com/r/rglab/gs-to-flowjo)
}
\details{
Docker images for \code{gatingset_to_flowjo} will be maintained at https://gallery.ecr.aws/x4k5d9i7/cytoverse/gs-to-wsp


\code{docker pull public.ecr.aws/x4k5d9i7/cytoverse/gs-to-wsp:latest}
}
\examples{
\dontrun{
library(flowWorkspace)

path <- system.file("extdata",package="flowWorkspaceData")
gs_path <- list.files(path, pattern = "gs_manual",full = TRUE)
gs <- load_gs(gs_path)

#output to flowJo
outFile <- tempfile(fileext = ".wsp")
gatingset_to_flowjo(gs, outFile)

#or directly use the archive as the input (to avoid the extra copying inside of the wrapper)
gatingset_to_flowjo(gs_path, outFile)
}
}
