% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diva2GatingSet.R
\name{open_diva_xml}
\alias{open_diva_xml}
\alias{openDiva}
\title{open Diva xml workspace}
\usage{
open_diva_xml(file, options = 0, ...)
}
\arguments{
\item{file}{xml file}

\item{options}{argument passed to \link{xmlTreeParse}}

\item{...}{arguments passed to \link{xmlTreeParse}}
}
\value{
a \code{diva_workspace} object
}
\description{
open Diva xml workspace
}
\examples{
\dontrun{
library(flowWorkspace)
library(CytoML)
ws <- open_diva_xml(system.file('extdata/diva/PE_2.xml', package = "flowWorkspaceData"))
ws
diva_get_sample_groups(ws)
gs <- diva_to_gatingset(ws, name = 2, subset = 1)
sampleNames(gs)
gs_get_pop_paths(gs)
plotGate(gs[[1]])
}
}
