% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_pval.R
\name{empirical_pval}
\alias{empirical_pval}
\title{Calculate empirical region-level p-value}
\usage{
empirical_pval(
  presa,
  design,
  rforiginal,
  coeff,
  cont,
  smooth,
  maxPerms = 10,
  Q,
  maxGap,
  method,
  ...
)
}
\arguments{
\item{presa}{SExperiment output from \code{calc_derivedasm} or
\code{calc_asm}.}

\item{design}{design matrix.}

\item{rforiginal}{data.frame of DAMEs calculated with original design.}

\item{coeff}{Coefficient of interest to permute.}

\item{cont}{same as in \code{get_tstats}.}

\item{smooth}{Boolean.}

\item{maxPerms}{Maximum possible permutations generated. Default = 10.}

\item{Q}{Quantile for cuttof.}

\item{maxGap}{Same as other functions in the package.}

\item{method}{lmFit method.}

\item{...}{Passed to \code{get_tstats} and then to \code{loessByCluster}.}
}
\value{
Vector of empirical p-values.
}
\description{
This function permutes the coefficient of interest and re-runs
\code{\link{get_tstats}} and \code{\link{regionFinder}} for each permutation.
Code for permutations copied from the \code{dmrseq} function from the package
of the same name.
}
\keyword{internal}
