% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methyl_circle_plot.R
\name{methyl_circle_plotCpG}
\alias{methyl_circle_plotCpG}
\title{Draw methylation circle plot without SNP}
\usage{
methyl_circle_plotCpG(
  cpgsite = cpgsite,
  bamFile = bamFile,
  pointSize = 3,
  refFile = refFile,
  dame = NULL,
  order = FALSE,
  sampleName = NULL,
  sampleReads = FALSE,
  numReads = 20
)
}
\arguments{
\item{cpgsite}{GRanges object containing a single CpG site location of
interest}

\item{bamFile}{bismark bam file path}

\item{pointSize}{Size of methylation circles. Default = 3.}

\item{refFile}{fasta reference file path}

\item{dame}{(optional) GRanges object containing a region to plot}

\item{order}{Whether reads should be sorted by methylation status. Default=
False.}

\item{sampleName}{Plot title.}

\item{sampleReads}{Whether a subset of reads should be plotted.
Default = FALSE.}

\item{numReads}{Number of reads to plot, if sampleReads is TRUE. Default = 20}
}
\value{
Plot
}
\description{
Draws CpG site methylation status as points, in reads containing a specific
CpG site. Generates one plot per bam file.
}
\examples{
DATA_PATH_DIR <- system.file('extdata', '.', package = 'DAMEfinder')
get_data_path <- function(file_name) file.path(DATA_PATH_DIR, file_name)
bam_files <- get_data_path('NORM1_chr19_trim.bam')
sample_names <- 'NORM1'
#reference_file
suppressPackageStartupMessages({library(BSgenome.Hsapiens.UCSC.hg19)})
genome <- BSgenome.Hsapiens.UCSC.hg19
seqnames(genome) <- gsub("chr","",seqnames(genome))
dna <- DNAStringSet(genome[[19]], use.names = TRUE)
names(dna) <- 19

cpg <- GenomicRanges::GRanges(19, IRanges::IRanges(292082, width = 1))
methyl_circle_plotCpG(cpgsite = cpg,
 bamFile = bam_files,
 refFile = dna)

}
