% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_simMat.R
\name{svm_simMat}
\alias{svm_simMat}
\title{Calculate stochastic transition matrix between clusters from a data frame 
including information about clustering}
\usage{
svm_simMat(dataframe)
}
\arguments{
\item{dataframe}{a data frame contains the information used for clustering 
and the original label of each cell. The original labels should have the 
column name `clusterRes`.}
}
\value{
a similarity matrix estimated by 5-fold cross validation support 
vector machine.
}
\description{
The transition probability from cluster i to j is calculated based on the 
information used to cluster cells. It is estimated by the misclassification 
rate from cluster i to j comparing the original labels with the labels predicted 
by support vector machine with 5-fold cross validation.
}
\examples{
data(Kang2017)
svm_mat = svm_simMat(Kang2017$svmDF)

}
