## DEP package

### Overview of the analysis

This package provides an integrated analysis workflow for robust and reproducible analysis of mass spectrometry proteomics data for differential protein expression or differential enrichment. 
It requires tabular input (e.g. txt files) as generated by quantitative analysis softwares of raw mass spectrometry data, such as [MaxQuant](http://www.nature.com/nbt/journal/v26/n12/full/nbt.1511.html) or [IsobarQuant](http://www.nature.com/nprot/journal/v10/n10/full/nprot.2015.101.html). 
Functions are provided for data preparation, filtering, variance normalization and imputation of missing values, as well as statistical testing of differentially enriched / expressed proteins.
It also includes tools to check intermediate steps in the workflow, such as normalization and missing values imputation.
Finally, visualization tools are provided to explore the results, including heatmap, volcano plot and barplot representations. 
For scientists with limited experience in R, the package also entails wrapper functions that entail the complete analysis workflow and generate a report.
Even easier to use are the interactive Shiny apps that are provided by the package.

### Installation

Install and load the package:

``` r
if (!requireNamespace("BiocManager", quietly=TRUE))
    install.packages("BiocManager")
BiocManager::install("DEP")

library("DEP")
```

More information can be found in the vignette:

``` r
browseVignettes("DEP")
```
