% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_dsp.R
\name{individual_dsp}
\alias{individual_dsp}
\title{individual_dsp}
\usage{
individual_dsp(
  spe,
  cluster_col,
  sample_col,
  condition_col,
  test = "QLF",
  min_counts = 20,
  min_non_zero_spots = 10,
  min_pct_cells = 0.5,
  filter_gene = TRUE,
  filter_cluster = TRUE
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment.}

\item{cluster_col}{Character. Column name of spatial clusters in \code{colData(spe)}.}

\item{sample_col}{Character. Column name of sample ids in \code{colData(spe)}.
Sample ids must be either a factor or character.}

\item{condition_col}{Character. Column name of condition ids in \code{colData(spe)}.}

\item{test}{Character. Either 'QLF' or 'LRT'. Default is 'QLF'. 
Specifies whether to perform quasi-likelihood F-tests (`edgeR::glmQLFTest`) or likelihood
ratio tests (`edgeR::glmLRT`). Quasi-likelihood tests apply empirical Bayes moderation to 
genewise dispersions, account for intra-sample variability, and provide more conservative error control.}

\item{min_counts}{Numeric. Minimum number of counts per sample (across all spots) for a gene to be analyzed.}

\item{min_non_zero_spots}{Numeric. Minimum number of non-zero spots per sample, for a gene to be analyzed.}

\item{min_pct_cells}{Numeric. Minimum percentage of cells required for each cluster to be 
included in the analysis across the specified conditions. 
Default value is 0.5 (i.e., 0.5\% of total cells per cluster per condition).}

\item{filter_gene}{Logical. If TRUE, 
\code{\link{dsp_test}} filters genes:
genes have to be expressed in at least 'min_non_zero_spots' spots, 
and a gene requires at least 'min_counts' counts per sample (across all locations).}

\item{filter_cluster}{Logical. When set to TRUE, \code{\link{dsp_test}} excludes clusters that are 
insufficiently represented in the dataset. Only clusters meeting the 'min_pct_cells' threshold 
(i.e., containing at least the specified percentage of cells across all conditions) will be retained for analysis.}
}
\value{
A list of results, with one result per spatial cluster in each element.
Specifically, each item in the list is a "gene_results" dataframe which contains main edgeR test results.
}
\description{
DESpace can also be used to reveal the specific areas of the tissue affected by DSP genes; i.e., spatial clusters that are particularly over/under abundant compared to the average signal across conditions.
This function can be used to identify SVGs among conditions for each individual cluster.
}
\examples{
# load the input data:
spe <- muSpaData::Wei22_example()
set.seed(123)
results_individual_dsp <- individual_dsp(spe,
                                          cluster_col = "Banksy_smooth",
                                          sample_col = "sample_id",
                                          condition_col = "condition")
                                           
# We visualize results for the cluster '3'
results <- results_individual_dsp[['3']]
head(results,3)

}
\seealso{
\code{\link{top_results}}, \code{\link{svg_test}}, \code{\link{dsp_test}}, \code{\link{FeaturePlot}}
}
