% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultsDEWSeq.R
\name{resultsDEWSeq}
\alias{resultsDEWSeq}
\title{extract DEWseq results}
\usage{
resultsDEWSeq(
  object,
  contrast,
  name,
  listValues = c(1, -1),
  cooksCutoff,
  test,
  addMLE = FALSE,
  tidy = FALSE,
  parallel = FALSE,
  BPPARAM = bpparam(),
  minmu = 0.5,
  start0based = TRUE
)
}
\arguments{
\item{object}{\code{DESeqDataSet}, on which the following functions has already been called:
\code{\link[DESeq2:nbinomWaldTest]{nbinomWaldTest}}}

\item{contrast}{\code{character vector}, \code{list of 2 character vectors} or \code{numeric contrast vector}
 contrast this argument specifies what comparison to extract from the \code{object} to build a results table,
see \code{\link[DESeq2:results]{results}}}

\item{name}{\code{character}, name the name of the individual effect (coefficient) for building a results table.
\code{name} argument is ignored if \code{contrast} is specified}

\item{listValues}{\code{list}, check \code{\link[DESeq2:results]{results}} for details of this parameter}

\item{cooksCutoff}{\code{numeric}, theshold on Cook's distance}

\item{test}{\code{character}, this is automatically detected internally if not provided.}

\item{addMLE}{\code{logical}, if \code{betaPrior=TRUE} was used}

\item{tidy}{\code{logical}, whether to output the results table with rownames as a first column 'row'.
The table will also be coerced to \code{data.frame}}

\item{parallel}{\code{logical}, if FALSE, no parallelization. if TRUE, parallel
execution using \code{BiocParallel}, see next argument \code{BPPARAM}}

\item{BPPARAM}{\code{bpparamClass}, an optional parameter object passed internally
to \code{\link{bplapply}} when \code{parallel=TRUE}.
If not specified, the parameters last registered with
\code{\link{register}} will be used.}

\item{minmu}{\code{numeric}, lower bound on the estimated count (used when calculating contrasts)}

\item{start0based}{\code{logical}, TRUE (default) or FALSE. If TRUE, then the start positions in \code{annotationFile} are  considered to be 0-based}
}
\value{
DESeqResults object
}
\description{
This is a modified version of the
     \code{\link[DESeq2:results]{results}} function from DESeq2 package.

This function uses chromosomal positions given in the \code{rowRanges(dds)}
to identify overlapping windows in \code{dds} object. For each window,
the number of overlapping windows are counted, and the p-value is
 adjusted for FWER using bonferroni correction.

For further details, please refer documentation for
 \code{\link[DESeq2:results]{results}} function in DESeq2 package
}
\details{
For a detailed description of the column use \code{mcols(output)$description}
}
\examples{

data("slbpDds")
slbpDds <- estimateSizeFactors(slbpDds)
slbpDds <- estimateDispersions(slbpDds)
slbpDds <- nbinomWaldTest(slbpDds)
slbpWindows <- resultsDEWSeq(slbpDds)

\dontrun{
# for a description of the columns in slbpWindows use
mcols(slbpWindows)$description
}


}
