% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePMDs.R
\name{mergePMDsIteratively}
\alias{mergePMDsIteratively}
\title{Merge PMDs iteratively}
\usage{
mergePMDsIteratively(
  PMDs,
  minGap = 200,
  respectSigns = TRUE,
  methylationData,
  context = "CG",
  minReadsPerCytosine = 4,
  minMethylation = 0.4,
  maxMethylation = 0.6,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{PMDs}{the list of PMDs as a \code{\link[GenomicRanges]{GRanges}} object; 
e.g. see \code{\link{computePMDs}}}

\item{minGap}{PMDs separated by a gap of at least \code{minGap} are not 
merged.}

\item{respectSigns}{logical value indicating whether to respect the sign when 
joining PMDs.}

\item{methylationData}{the methylation data in GRanges
(see \code{\link{ontSampleGRangesList}}).}

\item{context}{the context in which the PMDs are computed (\code{"CG"}, 
\code{"CHG"} 
or \code{"CHH"}).}

\item{minReadsPerCytosine}{two adjacent PMDs are merged only if the number of 
reads per cytosine of the new DMR is higher than \code{minReadsPerCytosine}.}

\item{minMethylation}{Numeric [0,1]; minimum mean methylation proportion.}

\item{maxMethylation}{Numeric [0,1]; maximum mean methylation proportion.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
the reduced list of PMDs as a \code{\link[GenomicRanges]{GRanges}} object; 
e.g. see \code{\link{computePMDs}}
}
\description{
This function takes a list of PMDs and attempts to merge PMDs while keeping 
the new PMDs statistically significant.
}
\examples{
# load the ONT methylation data 
data(ontSampleGRangesList)

# load the PMDs in CG context they were computed with minGap = 200
data(PMDsNoiseFilterCG)


# merge the PMDs 
PMDsNoiseFilterCGLarger <- mergePMDsIteratively(PMDsNoiseFilterCG[1:100], 
                           minGap = 500, respectSigns = TRUE, 
                           ontSampleGRangesList[["GM18501"]], context = "CG", 
                           minReadsPerCytosine = 4, minMethylation = 0.4, 
                           maxMethylation = 0.6, cores = 1)

\dontrun{
# set genomic coordinates where to compute PMDs
chr1_ranges <- GRanges(seqnames = Rle("chr1"), ranges = IRanges(1E6+5E5,2E6))

# compute PMDs and remove gaps smaller than 200 bp
PMDsNoiseFilterCG200 <- computePMDs(ontSampleGRangesList[["GM18501"]], 
                       regions = chr1_ranges, context = "CG", method = "noise_filter", 
                       windowSize = 100, kernelFunction = "triangular",  
                       minCytosinesCount = 1, minMethylation = 0.4, 
                       maxMethylation = 0.6, minGap = 0, minSize = 200, 
                       minReadsPerCytosine = 1, cores = 1)
PMDsNoiseFilterCG0 <- computePMDs(ontSampleGRangesList[["GM18501"]], 
                       regions = chr1_ranges, context = "CG", method = "noise_filter", 
                       windowSize = 100, kernelFunction = "triangular", 
                       minCytosinesCount = 1, minMethylation = 0.4, 
                       maxMethylation = 0.6, minGap = 0, minSize = 0, 
                       minReadsPerCytosine = 1, cores = 1)
PMDsNoiseFilterCG0Merged200 <- mergePMDsIteratively(PMDsNoiseFilterCG0, 
                             minGap = 200, respectSigns = TRUE, 
                             ontSampleGRangesList[["GM18501"]], context = "CG",  
                             minReadsPerCytosine = 4, minMethylation = 0.4, 
                             maxMethylation = 0.6, cores = 1)                      

#check that all newley computed PMDs are identical
print(all(PMDsNoiseFilterCG200 == PMDsNoiseFilterCG0Merged200))

}

}
\seealso{
\code{\link{filterPMDs}}, \code{\link{computePMDs}}, 
\code{\link{analyseReadsInsideRegionsForCondition}} and 
\code{\link{PMDsNoiseFilterCG}}
}
\author{
Nicolae Radu Zabet and Young Jun Kim
}
