% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{DaMiR.MDSplot}
\alias{DaMiR.MDSplot}
\title{Plot multidimentional scaling (MDS)}
\usage{
DaMiR.MDSplot(data, df, type = c("spearman", "pearson"))
}
\arguments{
\item{data}{A SummarizedExperiment object or a matrix or a data.frame
 where
rows and cols should be, respectively, observations and features}

\item{df}{A data frame with class; it can be directly subset from data}

\item{type}{A character string specifing the metric to be applied to
correlation
analysis. Either "spearman" or "pearson" is allowed; default is
"spearman"}
}
\value{
A MDS plot, using only 'class' information
}
\description{
A MDS plot is drawn in order to visualize class clustering.
}
\details{
The MDS plot is drawn taking as input a dissimilarity matrix
produced by either
a sample-per-sample Pearson's or Spearman's correlation of normalized
expression data.
}
\examples{
# use example data:
data(data_reduced)
data(df)
# Draw MDS:
DaMiR.MDSplot(data=data_reduced, df=df, type="pearson")

}
\author{
Mattia Chiesa, Luca Piacentini
}
