% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupProbPlot.R
\name{groupProbPlot}
\alias{groupProbPlot}
\title{Define and plot group probabilities}
\usage{
groupProbPlot(
  xYData,
  groupVector,
  euclidSpaceData,
  kNeighK = max(100, round(nrow(euclidSpaceData)/10000)),
  kMeansK = round(nrow(euclidSpaceData)/1000),
  densContour = TRUE,
  groupName1 = unique(groupVector)[1],
  groupName2 = unique(groupVector)[2],
  plotName = "default",
  title = FALSE,
  bandColor = "black",
  plotDir = ".",
  dotSize = 400/sqrt(nrow(xYData)),
  returnProb = FALSE,
  returnProbColVec = FALSE,
  createOutput = TRUE
)
}
\arguments{
\item{xYData}{A dataframe or matrix with two columns. Each row contains
information about the x and y positition in the field for that observation.}

\item{groupVector}{Vector with the same length as xYData containing
information about the group identity of each observation.}

\item{euclidSpaceData}{The data cloud in which the nearest neighbors for the
events should be identified.}

\item{kNeighK}{The number of nearest neighbors.}

\item{kMeansK}{The number of clusters in the initial step of the algorithm.
A higher number leads to shorter runtime, but potentially lower accuracy.}

\item{densContour}{If density contours should be created for the plot(s) or
not. Defaults to TRUE. a}

\item{groupName1}{The name for the first group}

\item{groupName2}{The name for the second group}

\item{plotName}{The main name for the graph and the analysis.}

\item{title}{If there should be a title displayed on the plotting field. As
the plotting field is saved as a png, this title cannot be removed as an
object afterwards, as it is saved as coloured pixels. To simplify usage for
publication, the default is FALSE, as the files are still named, eventhough
no title appears on the plot.}

\item{bandColor}{The color of the contour bands. Defaults to black.}

\item{plotDir}{If different from the current directory. If specified and
non-existent, the function creates it. If "." is specified, the plots will be
saved at the current directory.}

\item{dotSize}{Simply the size of the dots. The default makes the dots
smaller the more observations that are included.}

\item{returnProb}{Should a probability vector be returned? Mutually exclusive
with returnProbColVec.}

\item{returnProbColVec}{Should the color vector be returned as part of the
output? Mutually exclusive with returnProb.}

\item{createOutput}{For testing purposes. Defaults to TRUE. If FALSE, no
output is generated.}
}
\value{
A graph showing the probability as a color scale from blue over white
to red for each event to belong to one group or the other, with a separate
color scale. Optionally also the color vector, if returnProbColVec is TRUE.
}
\description{
This function defines and plots the single-observation probability for
belonging to either of two groups. It uses the \code{\link{neighSmooth}}
function with the special case that the values are binary: For each set of
k nearest neighbors, cell x is assigned a probability to belong to one group
or the other based on the percentage of the neighbors belonging to each
group. In other words, if 20 out of 100 neighbors belong to group
A and 80 belong to group B, and the value for the cell will be 20% for group
A or 80% for group B, depending on the point of view. This will also be
accordingly reflected in the color scale on the resulting plot.
}
\examples{
data(testData)
data(testDataSNE)
euclidSpaceData <-
    testData[, c(
        "SYK", "CD16", "CD57", "EAT.2",
        "CD8", "NKG2C", "CD2", "CD56"
    )]
\dontrun{
groupProbPlot(
    xYData = testDataSNE$Y, groupVector = testData$label,
    euclidSpaceData
)
}

}
