test_that("saving and loading returns same object",{
  
  data(tamoxifen_greylist)
  data(tamoxifen_peaks)
  dba.save(tamoxifen,"testDBA")
  testDBA <- dba.load("testDBA")
  expect_is(testDBA,"DBA")
  expect_equal(sum(!(names(testDBA) %in% names(tamoxifen))),0)
  tamoxifen <- dba.blacklist(testDBA, blacklist=DBA_BLACKLIST_HG19,
                             greylist=tamoxifen.greylist$master)
  dba.save(tamoxifen,"testDBA")
  testDBA <- dba.load("testDBA")
  expect_is(testDBA,"DBA")
  expect_equal(sum(!(names(testDBA) %in% names(tamoxifen))),0)
  x <- dba.blacklist(testDBA,Retrieve=DBA_BLACKLIST)
  x <- dba.blacklist(testDBA,Retrieve=DBA_GREYLIST)
  expect_equal(sum(x != tamoxifen.greylist$master),0)
  x <- dba.blacklist(testDBA,Retrieve=DBA_BLACKLISTED_PEAKS)
  
  expect_identical(dim(tamoxifen$merged),  dim(testDBA$merged)) 
  expect_identical(dim(tamoxifen$binding), dim(testDBA$binding)) 
  expect_identical(dim(tamoxifen$called),  dim(testDBA$called)) 
  expect_identical(dim(testDBA$called),    dim(testDBA$binding[,-c(1:3)]))   
  expect_identical(nrow(testDBA$allcalled), nrow(testDBA$merged)) 
  
  rm(tamoxifen)
  data(tamoxifen_counts)
  dba.save(tamoxifen,"testDBA")
  testDBA <- dba.load("testDBA")
  expect_is(testDBA,"DBA")
  expect_equal(sum(!(names(testDBA) %in% names(tamoxifen))),0)
  tamoxifen <- dba.blacklist(testDBA, blacklist=DBA_BLACKLIST_HG19,
                             greylist=tamoxifen.greylist$master)
  dba.save(tamoxifen,"testDBA")
  testDBA <- dba.load("testDBA")
  expect_is(testDBA,"DBA")
  expect_equal(sum(!(names(testDBA) %in% names(tamoxifen))),0)
  x <- dba.blacklist(testDBA,Retrieve=DBA_BLACKLIST)
  x <- dba.blacklist(testDBA,Retrieve=DBA_GREYLIST)
  expect_equal(sum(x != tamoxifen.greylist$master),0)
  x <- dba.blacklist(testDBA,Retrieve=DBA_BLACKLISTED_PEAKS)
  
  expect_identical(dim(tamoxifen$merged),  dim(testDBA$merged)) 
  expect_identical(dim(tamoxifen$binding), dim(testDBA$binding)) 
  expect_identical(dim(tamoxifen$called),  dim(testDBA$called)) 
  expect_identical(dim(testDBA$called),    dim(testDBA$binding[,-c(1:3)]))  
  
  rm(tamoxifen)
  data(tamoxifen_counts)
  tamoxifen <- dba.contrast(tamoxifen,design="~Tissue+Condition")
  tamoxifen <- dba.analyze(tamoxifen,method=DBA_ALL_METHODS)
  rep1 <- dba.report(tamoxifen)
  showsamps1 <- dba.show(tamoxifen) 
  showcons1  <- dba.show(tamoxifen,bContrast=TRUE) 
  showdes1   <- dba.show(tamoxifen,bDesign=TRUE)
  dba.save(tamoxifen,"testDBA")
  testDBA <- dba.load("testDBA")
  expect_is(testDBA,"DBA")
  expect_equal(sum(!(names(testDBA) %in% names(tamoxifen))),0)
  rep2 <- dba.report(testDBA)
  expect_equal(sum(rep1!=rep2),0)  
  showsamps2 <- dba.show(testDBA) 
  showcons2  <- dba.show(testDBA,bContrast=TRUE) 
  showdes2   <- dba.show(testDBA,bDesign=TRUE)
  expect_equal(sum(showsamps1!=showsamps2),0) 
  expect_equal(sum(showcons1!=showcons2),0) 
  expect_equal(sum(showdes1!=showdes2),0) 
  
  expect_identical(dim(tamoxifen$merged),  dim(testDBA$merged)) 
  expect_identical(dim(tamoxifen$binding), dim(testDBA$binding)) 
  expect_identical(dim(tamoxifen$called),  dim(testDBA$called)) 
  expect_identical(dim(testDBA$called),    dim(testDBA$binding[,-c(1:3)]))  
  
  unlink("dba_testDBA.RData")
})