% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{discoBatch}
\alias{discoBatch}
\title{Core DiscoRhythm Workflow}
\usage{
discoBatch(
  indata,
  report = NULL,
  outdata = TRUE,
  ncores = 1,
  timeType = "circular",
  main_per = 24,
  cor_threshold = 3,
  cor_method = "pearson",
  cor_threshType = "sd",
  pca_threshold = 3,
  pca_scale = TRUE,
  pca_pcToCut = paste0("PC", seq_len(4)),
  aov_method = "None",
  aov_pcut = 0.05,
  aov_Fcut = 0,
  avg_method = "Median",
  osc_method = NULL,
  osc_period = 24
)
}
\arguments{
\item{indata}{SummarizedExperiment or data.frame, see the vignette for
the specific formats expected for each of these input types.
\code{discoParseMeta}.}

\item{report}{character, if \code{!is.null(report)} an html report with}

\item{outdata}{logical, whether to return the final discoODAs (note if run
with \code{is.null(report)} discoBatch will return nothing).}

\item{ncores}{numeric, number of cores to use for parallelized tasks.
Currently, only used in oscillation detection function \code{discoODAs}.}

\item{timeType}{character, nature of the sample times provided
(one of \code{"circular"} or \code{"linear"}).}

\item{main_per}{numeric, the length of the main hypothesized period
(e.g. 24hr for circadian experiments). Used in \code{discoPeriodDetection}.}

\item{cor_threshold}{numeric, threshold used in inter-sample correlation
analysis for outlier detection. Either in units of correlation coefficient
or standard deviations from the mean (see \code{cor_threshType}).}

\item{cor_method}{character, which correlation method to use for outlier
removal (see \link[stats]{cor} for more details).}

\item{cor_threshType}{character, one of "sd" or "value" indicating whether
cor_threshold should be set by absolute correlation coefficient or by
standard deviations from the mean of all samples.}

\item{pca_threshold}{numeric, the number of standard deviations to set as
the threshold for outlier detection in PCA outlier removal.}

\item{pca_scale}{logical, whether to scale the data prior to PCA.}

\item{pca_pcToCut}{character, names of which PCs to use for outlier
detection (e.g. "PC1","PC2" etc.).}

\item{aov_method}{character, method to use for ANOVA. One of:
"Equal Variance", "Welch", or "None".}

\item{aov_pcut}{numeric, p-value cutoff used to select rows with
statistically significant signal-to-noise.}

\item{aov_Fcut}{numeric, F-statistic cutoff used to select rows
with high signal-to-noise based on magnitude.}

\item{avg_method}{character, method for averaging technical replicates. One
of: "Median","Mean","Random", or "None".}

\item{osc_method}{character, vector of oscillation detection algorithms
to apply to the data. Methods that are detmined to be innappropraite for the
experimental design (using the \code{discoODAexclusionMatrix}) will be
ignored. If \code{is.null(osc_method)} all
suitable methods will be executed.}

\item{osc_period}{numeric, a fixed period to use for oscillation detection
using all methods.}
}
\value{
returns the results of \code{discoODAs}
}
\description{
Execute the DiscoRhythm workflow with one command to obtain the results
of oscillation detection (\code{discoODAs}) and optionally generate an html
report with data visualizations from an Rmarkdown template. See the
DiscoRhythm vignette for more details on the analysis procedures.
}
\examples{
indata <- discoGetSimu()

# Batch execute (on demo data) to generate a DiscoRhythm_report.html report.
# Returns the results of discoODAs
discoODAres <- discoBatch(indata,
report="DiscoRhythm_report.html",
osc_method="CS")

}
\seealso{
discoODAs, discoRepAnalysis, discoPeriodDetection,
discoPCAoutliers, discoInterCorOurliers
}
