% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{RNADuplexSampleClustReads}
\alias{RNADuplexSampleClustReads}
\title{RNA duplex reads of SPLASH, clustered and assigned to duplex groups}
\format{
An object of class \code{StrictGInteractions} of length 2090.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR3404943}{SequenceReadArcive}
Reads were aligned with STAR and duplex groups were identified
see \code{system.file("extdata/scripts", "DD_data_generation.R", package =
"DuplexDiscovereR")} for details on the data generation proccedure.
}
\usage{
data(RNADuplexesSampleData)
}
\value{
\code{GInteractions} with
\itemize{
\item \code{n_reads_dg } : number of reads in the duplex group (DG)
\item \code{duplex_id  } : temporary id for RNA duplexes which could be found before
clustering (duplicated or shifted by couple of nt )
\item \code{dg_id} :id of the duplex group
\item \code{score} : median alignment score in duplex group
\item other columns inherited from the STAR Chimeric.out.Junction
}
}
\description{
\code{GInteractions} read-level object containing processed reads,annotated with duplex group
ids, read types gene names and p-values
}
\keyword{datasets}
