% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\alias{pdistr}
\alias{volcano}
\alias{exprsHeatmap}
\title{Visualization of gene expression}
\usage{
pdistr(p)

volcano(fc, p)

exprsHeatmap(expr, grp, scale.rows = TRUE)
}
\arguments{
\item{p}{Numeric vector of p-values for each gene.}

\item{fc}{Numeric vector of fold changes (typically on log2 scale).}

\item{expr}{Expression matrix. Rows correspond to genes, columns to samples.}

\item{grp}{*BINARY* group assignment for the samples.  Use '0' and '1' for
unaffected (controls) and affected (cases) samples, respectively.}

\item{scale.rows}{Should rows of the expression matrix be scaled for better
visibility of expression differences between sample groups? Defaults to
TRUE.}
}
\value{
None, plots to a graphics device.
}
\description{
Visualization of differential gene expression via heatmap, p-value histogram
and volcano plot (fold change vs. p-value).
}
\examples{

    # (1) simulating expression data: 100 genes, 12 samples
    se <- makeExampleData(what="SE") 
    
    # plot heatmap
    exprsHeatmap(expr=assay(se), grp=as.factor(se$GROUP))

    # (2) DE analysis
    se <- deAna(se)
    pdistr(rowData(se)$ADJ.PVAL)
    volcano(fc=rowData(se)$FC, p=rowData(se)$ADJ.PVAL)

}
\seealso{
\code{\link{deAna}} for differential expression analysis,
\code{ComplexHeatmap::Heatmap}, and \code{\link{hist}} for generic plotting.
}
\author{
Ludwig Geistlinger
}
