% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSpatialExperiment.R, R/SubsetTreeSummarizedExperiment.R
\name{reducedDimNames<-}
\alias{reducedDimNames<-}
\alias{reducedDimNames<-,ANY-method}
\title{reducedDimNames<-}
\usage{
reducedDimNames(x, subsetName) <- value

\S4method{reducedDimNames}{ANY}(x, subsetName) <- value

\S4method{reducedDimNames}{ANY}(x, subsetName) <- value

\S4method{reducedDimNames}{ANY}(x, subsetName) <- value
}
\arguments{
\item{x}{Input \code{ExperimentSubset} object or any object supported by \code{reducedDimNames<-} from \link[SingleCellExperiment]{reducedDims} method.}

\item{subsetName}{Specify the name of the subset to which the \code{reducedDimNames<-} should be set to. If \code{missing}, \code{reducedDimNames<-} from \link[SingleCellExperiment]{reducedDims} method is called on the main object.}

\item{value}{Input value same as \code{reducedDimNames<-} from \link[SingleCellExperiment]{reducedDims} method.}
}
\value{
Input object with \code{reducedDimNames<-} set.
}
\description{
A wrapper to the \code{reducedDimNames<-} from \link[SingleCellExperiment]{reducedDims} method with additional support for subsets.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es, "subset1",
rows = c(1:1500), cols = c(1:1500),
parentAssay = "counts")
reducedDims(es, subsetName = "subset1") <- list(
PCA_1 = scater::calculatePCA(assay(es, "subset1")),
PCA_2 = scater::calculatePCA(assay(es, "subset1")))
reducedDimNames(es, subsetName = "subset1") <- c("rDim1", "rDim2")
}
