% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetColnames}
\alias{subsetColnames}
\alias{subsetColnames<-}
\alias{subsetColnames,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetColnames<-,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetColnames,SubsetSingleCellExperiment,character-method}
\alias{subsetColnames<-,SubsetSingleCellExperiment,character-method}
\alias{subsetColnames,SubsetSummarizedExperiment,character-method}
\alias{subsetColnames<-,SubsetSummarizedExperiment,character-method}
\alias{subsetColnames,SubsetSpatialExperiment,character-method}
\alias{subsetColnames<-,SubsetSpatialExperiment,character-method}
\alias{subsetColnames,SubsetTreeSummarizedExperiment,character-method}
\alias{subsetColnames<-,SubsetTreeSummarizedExperiment,character-method}
\title{subsetColnames}
\usage{
subsetColnames(x, subsetName)

subsetColnames(x, subsetName) <- value

\S4method{subsetColnames}{SubsetRangedSummarizedExperiment,character}(x, subsetName)

\S4method{subsetColnames}{SubsetRangedSummarizedExperiment,character}(x, subsetName) <- value

\S4method{subsetColnames}{SubsetSingleCellExperiment,character}(x, subsetName)

\S4method{subsetColnames}{SubsetSingleCellExperiment,character}(x, subsetName) <- value

\S4method{subsetColnames}{SubsetSummarizedExperiment,character}(x, subsetName)

\S4method{subsetColnames}{SubsetSummarizedExperiment,character}(x, subsetName) <- value

\S4method{subsetColnames}{SubsetSpatialExperiment,character}(x, subsetName)

\S4method{subsetColnames}{SubsetSpatialExperiment,character}(x, subsetName) <- value

\S4method{subsetColnames}{SubsetTreeSummarizedExperiment,character}(x, subsetName)

\S4method{subsetColnames}{SubsetTreeSummarizedExperiment,character}(x, subsetName) <- value
}
\arguments{
\item{x}{Input \code{ExperimentSubset} object.}

\item{subsetName}{Name of the subset to set \code{colnames} to.}

\item{value}{Specify the colname values to replace.}
}
\value{
A \code{vector} of \code{colnames}.

Input object with colnames set to a subset.
}
\description{
Get \code{colnames} from a subset in the \code{ExperimentSubset} object.

Set \code{colnames} to a subset in the \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetColnames(es, "subset1")
}
