% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-BulkPipeline.R
\name{bulk_long_pipeline}
\alias{bulk_long_pipeline}
\title{Pipeline for bulk long read RNA-seq data processing (deprecated)}
\usage{
bulk_long_pipeline(
  annotation,
  fastq,
  outdir,
  genome_fa,
  minimap2 = NULL,
  config_file
)
}
\arguments{
\item{annotation}{The file path to the annotation file in GFF3 / GTF format.}

\item{fastq}{Path to the FASTQ file or a directory containing FASTQ files. Each file
will be processed as an individual sample.}

\item{outdir}{Path to the output directory. If it does not exist, it will be created.}

\item{genome_fa}{The file path to the reference genome in FASTA format.}

\item{minimap2}{(optional) The path to the minimap2 binary. If not provided, FLAMES will
use a copy from bioconda via \code{basilisk}.}

\item{config_file}{Path to the JSON configuration file. See \code{\link{create_config}} for creating one.}
}
\value{
A \code{SummarizedExperiment} object containing the transcript counts.
}
\description{
This function is deprecated. Use \code{\link{BulkPipeline}} instead.
}
\examples{
outdir <- tempfile()
dir.create(outdir)
# simulate 3 samples via sampling
reads <- ShortRead::readFastq(
  system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES")
)
dir.create(file.path(outdir, "fastq"))
ShortRead::writeFastq(reads[1:100],
  file.path(outdir, "fastq/sample1.fq.gz"),
  mode = "w", full = FALSE
)
reads <- reads[-(1:100)]
ShortRead::writeFastq(reads[1:100],
  file.path(outdir, "fastq/sample2.fq.gz"),
  mode = "w", full = FALSE
)
reads <- reads[-(1:100)]
ShortRead::writeFastq(reads,
  file.path(outdir, "fastq/sample3.fq.gz"),
  mode = "w", full = FALSE
)
# prepare the reference genome
genome_fa <- file.path(outdir, "rps24.fa")
R.utils::gunzip(
  filename = system.file("extdata", "rps24.fa.gz", package = "FLAMES"),
  destname = genome_fa, remove = FALSE
)
se <- bulk_long_pipeline(
  fastq = file.path(outdir, "fastq"),
  annotation = system.file("extdata", "rps24.gtf.gz", package = "FLAMES"),
  outdir = outdir, genome_fa = genome_fa,
  config_file = create_config(outdir, type = "sc_3end", threads = 1, no_flank = TRUE)
)
se
}
\seealso{
\code{\link{BulkPipeline}} for the new pipeline function.
\code{\link{SingleCellPipeline}} for single cell pipelines,
\code{\link{MultiSampleSCPipeline}} for multi sample single cell pipelines.
}
