% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePSIValue.R
\name{calculatePSIValues}
\alias{calculatePSIValues}
\title{PSI value calculation}
\usage{
calculatePSIValues(
  fds,
  types = psiTypes,
  overwriteCts = FALSE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{fds}{A \code{\link{FraserDataSet}} object}

\item{types}{A vector with the psi types which should be calculated. Default 
is all of jaccard, psi5, psi3 and theta.}

\item{overwriteCts}{FALSE or TRUE (the default) the total counts (aka N) will
be recalculated based on the existing junction counts (aka K)}

\item{BPPARAM}{the BiocParallel parameters for the parallelization}
}
\value{
FraserDataSet
}
\description{
This function calculates the PSI values for each junction and splice site
based on the FraserDataSet object
}
\examples{
  fds <- createTestFraserDataSet()
  fds <- calculatePSIValues(fds, types="jaccard")
  
  ### usually one would run this function for all psi types by using:
  # fds <- calculatePSIValues(fds)
}
