% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics-definitions.R, R/filterExpression.R
\name{filterVariability}
\alias{filterVariability}
\alias{filtering}
\alias{filterExpressionAndVariability}
\alias{filterExpression,FraserDataSet-method}
\alias{filterVariability,FraserDataSet-method}
\title{Filtering FraserDataSets}
\usage{
filterVariability(object, ...)

filterExpressionAndVariability(
  object,
  minExpressionInOneSample = 20,
  quantile = 0.75,
  quantileMinExpression = 10,
  minDeltaPsi = 0,
  filter = TRUE,
  delayed = ifelse(ncol(object) <= 300, FALSE, TRUE),
  filterOnJaccard = TRUE,
  BPPARAM = bpparam()
)

\S4method{filterExpression}{FraserDataSet}(
  object,
  minExpressionInOneSample = 20,
  quantile = 0.75,
  quantileMinExpression = 10,
  filter = TRUE,
  delayed = ifelse(ncol(object) <= 300, FALSE, TRUE),
  filterOnJaccard = TRUE,
  BPPARAM = bpparam()
)

\S4method{filterVariability}{FraserDataSet}(
  object,
  minDeltaPsi = 0,
  filter = TRUE,
  delayed = ifelse(ncol(object) <= 300, FALSE, TRUE),
  filterOnJaccard = TRUE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{object}{A \code{\link{FraserDataSet}} object}

\item{...}{Further parameters passed on to Rsubread::featureCounts.}

\item{minExpressionInOneSample}{The minimal read count in at least one 
sample that is required for an intron to pass the filter.}

\item{quantile}{Defines which quantile should be considered for the filter.}

\item{quantileMinExpression}{The minimum read count an intron needs to have 
at the specified quantile to pass the filter.}

\item{minDeltaPsi}{Only introns for which the maximal difference in the psi 
value of a sample to the mean psi of the intron is larger than this value 
pass the filter.}

\item{filter}{If TRUE, a subsetted fds containing only the introns that 
passed all filters is returned. If FALSE, no subsetting is done and the 
information of whether an intron passed the filters is only stored in the 
mcols.}

\item{delayed}{If FALSE, count matrices will be loaded into memory, 
otherwise the function works on the delayedMatrix representations. The 
default value depends on the number of samples in the fds-object.}

\item{filterOnJaccard}{If TRUE, the Intron Jaccard Metric is used to define 
express introns during fitlering. Otherwise, the psi5, psi3 and theta 
metrics are used (default: TRUE).}

\item{BPPARAM}{the BiocParallel parameters for the parallelization}
}
\value{
A FraserDataSet with information about which junctions passed the
filters. If \code{filter=TRUE}, the filtered FraserDataSet is returned.
}
\description{
This method can be used to filter out introns that are not 
reliably detected and to remove introns with no variablity between samples.
}
\section{Functions}{
\itemize{
\item \code{filterExpressionAndVariability()}: This functions filters out both introns with low 
read support and introns that are not variable across samples.

\item \code{filterExpression(FraserDataSet)}: This function filters out introns and corresponding 
splice sites that have low read support in all samples.

\item \code{filterVariability(FraserDataSet)}: This function filters out introns and corresponding 
splice sites that have low read support in all samples.

}}
\examples{
fds <- createTestFraserDataSet()
fds <- filterExpressionAndVariability(fds, minDeltaPsi=0.1, filter=FALSE)
mcols(fds, type="jaccard")[, c(
        "maxCount", "passedExpression", "maxDJaccard", "passedVariability")]

plotFilterExpression(fds)
plotFilterVariability(fds)     

}
