% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNSetterFuns.R
\name{getter_setter_functions}
\alias{getter_setter_functions}
\alias{zScore,}
\alias{pVals,}
\alias{padjVals,}
\alias{rho,}
\alias{bestQ}
\alias{featureExclusionMask}
\alias{featureExclusionMask,}
\alias{`featureExclusionMask<-`}
\alias{featureExclusionMask<-}
\alias{rho}
\alias{zScores}
\alias{pVals}
\alias{padjVals}
\alias{availableFDRsubsets}
\alias{predictedMeans}
\alias{deltaPsiValue}
\alias{currentType}
\alias{currentType<-}
\alias{fitMetrics}
\alias{fitMetrics<-}
\alias{pseudocount}
\alias{hyperParams}
\alias{dontWriteHDF5}
\alias{dontWriteHDF5<-}
\alias{verbose}
\alias{verbose<-}
\title{Getter/Setter functions}
\usage{
featureExclusionMask(fds, type = currentType(fds))

featureExclusionMask(fds, type = currentType(fds)) <- value

rho(fds, type = currentType(fds))

zScores(fds, type = currentType(fds), byGroup = FALSE, ...)

pVals(
  fds,
  type = currentType(fds),
  level = "site",
  filters = list(),
  dist = "BetaBinomial",
  ...
)

padjVals(
  fds,
  type = currentType(fds),
  dist = c("BetaBinomial"),
  level = "site",
  subsetName = NULL,
  filters = list(),
  ...
)

availableFDRsubsets(fds)

predictedMeans(fds, type = currentType(fds))

deltaPsiValue(fds, type = currentType(fds))

currentType(fds)

currentType(fds) <- value

fitMetrics(fds)

fitMetrics(fds) <- value

pseudocount(value = NULL)

hyperParams(fds, type = currentType(fds), all = FALSE)

bestQ(fds, type = currentType(fds))

dontWriteHDF5(fds)

dontWriteHDF5(fds) <- value

verbose(fds)

verbose(fds) <- value
}
\arguments{
\item{fds}{An FraserDataSet object.}

\item{type}{The type of psi (psi5, psi3 or theta)}

\item{value}{The new value to be assigned.}

\item{byGroup}{If TRUE, aggregation by donor/acceptor site will be done.}

\item{...}{Internally used parameters.}

\item{level}{Indicates if the retrieved p values should be adjusted on the 
donor/acceptor site-level (default) or if unadjusted junction-level 
p values should be returned.}

\item{filters}{A named list giving the filters that were applied for masking 
during p value correction. Used for storing and retrieving the 
correct set of requested p values.}

\item{dist}{Distribution for which the p-values should be extracted.}

\item{subsetName}{The name of a subset of genes of interest for which FDR 
corrected pvalues were previously computed. 
Default is NULL (using transcriptome-wide FDR corrected pvalues).}

\item{all}{Logical value indicating whether \code{hyperParams(fds)} should 
return the results of all evaluated parameter combinations or only 
for the optimal parameter combination.}
}
\value{
A (delayed) matrix or vector dependent on the type of data retrieved.
}
\description{
This is a collection of small accessor/setter functions for easy access to
the values within the FRASER model.
}
\section{Functions}{
\itemize{
\item \code{featureExclusionMask()}: Retrieves a logical vector indicating
for each junction whether it is included or excluded during the fitting
procedure.

\item \code{featureExclusionMask(fds, type = currentType(fds)) <- value}: To remove certain junctions from 
being used in the train step of the encoding dimension we can set the 
\code{featureExclusion} vector to \code{FALSE}. This can be helpfull 
if we have local linkage between features which we do not want to 
model by the autoencoder.

\item \code{rho()}: Returns the fitted rho values for the 
beta-binomial distribution

\item \code{zScores()}: This returns the calculated z-scores.

\item \code{pVals()}: This returns the calculated p-values.

\item \code{padjVals()}: This returns the adjusted p-values.

\item \code{availableFDRsubsets()}: This returns the names of FDR subsets 
for which adjusted p values have been calculated.

\item \code{predictedMeans()}: This returns the fitted mu (i.e. psi) 
values.

\item \code{deltaPsiValue()}: Returns the difference between the 
observed and the fitted psi values.

\item \code{currentType()}: Returns the psi type that is used 
within several methods in the FRASER package (defaults to jaccard).

\item \code{currentType(fds) <- value}: Sets the psi type that is to be used 
within several methods in the FRASER package.

\item \code{fitMetrics()}: Returns the splice metrics that will be
fitted (defaults to jaccard, used within several methods in the 
FRASER package).

\item \code{fitMetrics(fds) <- value}: Sets the splice metrics that will be 
fitted (used within several methods in the FRASER package).

\item \code{pseudocount()}: Sets and returns the pseudo count used 
within the FRASER fitting procedure.

\item \code{hyperParams()}: This returns the results of OHT or the 
hyperparameter optimization. It returns NULL if \code{\link{estimateBestQ}}
was not run yet.

\item \code{bestQ()}: This returns the optimal latent space
dimension estimated by OHT or a hyperparameter optimization. If  
\code{\link{estimateBestQ}} has not been run before, a simple estimate of 
about a tenth of the number of samples is returned.

\item \code{dontWriteHDF5()}: Gets the current value of whether the 
assays should be stored as hdf5 files.

\item \code{dontWriteHDF5(fds) <- value}: Sets whether the assays should be stored 
as hdf5 files.

\item \code{verbose()}: Dependent on the level of verbosity 
the algorithm reports more or less to the user. 0 means being quiet 
and 10 means everything.

\item \code{verbose(fds) <- value}: Sets the verbosity level to a value 
between 0 and 10. 0 means being quiet and 10 means reporting everything.

}}
\examples{
fds <- createTestFraserDataSet()

# should assays be saved as hdf5? 
dontWriteHDF5(fds)
dontWriteHDF5 <- TRUE

# get/set the splice metric for which results should be retrieved 
currentType(fds) <- "jaccard"
currentType(fds)

# get fitted parameters
bestQ(fds)
predictedMeans(fds)
rho(fds)

# get statistics
pVals(fds)
padjVals(fds)

# zscore not calculated by default
fds <- calculateZscore(fds, type="jaccard")
zScores(fds)

# set and get pseudocount
pseudocount(4L)
pseudocount()

# retrieve or set a mask to exclude certain junctions in the fitting step
featureExclusionMask(fds, type="jaccard") <- sample(
        c(FALSE, TRUE), nrow(mcols(fds, type="jaccard")), replace=TRUE)
featureExclusionMask(fds, type="jaccard")

# controlling the verbosity level of the output of some algorithms
verbose(fds) <- 2
verbose(fds)
}
