% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics-definitions.R, R/plotMethods.R
\name{plotManhattan}
\alias{plotManhattan}
\alias{plotFunctions}
\alias{plotAberrantPerSample}
\alias{plotVolcano}
\alias{plotQQ}
\alias{plotExpression}
\alias{plotCountCorHeatmap}
\alias{plotFilterExpression}
\alias{plotExpectedVsObservedPsi}
\alias{plotEncDimSearch}
\alias{plotBamCoverage}
\alias{plotBamCoverageFromResultTable}
\alias{plotVolcano,FraserDataSet-method}
\alias{plotAberrantPerSample,FraserDataSet-method}
\alias{plotSpliceMetricRank}
\alias{plotQQ,FraserDataSet-method}
\alias{plotEncDimSearch,FraserDataSet-method}
\alias{plotFilterVariability}
\alias{plotCountCorHeatmap,FraserDataSet-method}
\alias{plotManhattan,FraserDataSet-method}
\title{Visualization functions for FRASER}
\usage{
plotManhattan(object, ...)

\S4method{plotVolcano}{FraserDataSet}(
  object,
  sampleID,
  type = fitMetrics(object),
  basePlot = TRUE,
  aggregate = FALSE,
  main = NULL,
  label = NULL,
  deltaPsiCutoff = 0.1,
  padjCutoff = 0.1,
  subsetName = NULL,
  ...
)

\S4method{plotAberrantPerSample}{FraserDataSet}(
  object,
  main,
  type = fitMetrics(object),
  padjCutoff = 0.1,
  deltaPsiCutoff = 0.1,
  aggregate = TRUE,
  subsetName = NULL,
  BPPARAM = bpparam(),
  ...
)

plotExpression(
  fds,
  type = fitMetrics(fds),
  idx = NULL,
  result = NULL,
  colGroup = NULL,
  basePlot = TRUE,
  main = NULL,
  label = "aberrant",
  subsetName = NULL,
  ...
)

plotSpliceMetricRank(
  fds,
  type = fitMetrics(fds),
  idx = NULL,
  result = NULL,
  colGroup = NULL,
  basePlot = TRUE,
  main = NULL,
  label = "aberrant",
  subsetName = NULL,
  ...
)

plotExpectedVsObservedPsi(
  fds,
  type = fitMetrics(fds),
  idx = NULL,
  result = NULL,
  colGroup = NULL,
  main = NULL,
  basePlot = TRUE,
  label = "aberrant",
  subsetName = NULL,
  ...
)

\S4method{plotQQ}{FraserDataSet}(
  object,
  type = NULL,
  idx = NULL,
  result = NULL,
  aggregate = FALSE,
  global = FALSE,
  main = NULL,
  conf.alpha = 0.05,
  samplingPrecision = 3,
  basePlot = TRUE,
  label = "aberrant",
  Ncpus = min(3, getDTthreads()),
  subsetName = NULL,
  ...
)

\S4method{plotEncDimSearch}{FraserDataSet}(object, type = psiTypes, plotType = c("sv", "auc", "loss"))

plotFilterExpression(
  fds,
  bins = 200,
  legend.position = c(0.8, 0.8),
  onlyVariableIntrons = FALSE
)

plotFilterVariability(
  fds,
  bins = 200,
  legend.position = c(0.8, 0.8),
  onlyExpressedIntrons = FALSE
)

\S4method{plotCountCorHeatmap}{FraserDataSet}(
  object,
  type = psiTypes,
  logit = FALSE,
  topN = 50000,
  topJ = 5000,
  minMedian = 1,
  minCount = 10,
  main = NULL,
  normalized = FALSE,
  show_rownames = FALSE,
  show_colnames = FALSE,
  minDeltaPsi = 0.1,
  annotation_col = NA,
  annotation_row = NA,
  border_color = NA,
  nClust = 5,
  plotType = c("sampleCorrelation", "junctionSample"),
  sampleClustering = NULL,
  plotMeanPsi = TRUE,
  plotCov = TRUE,
  ...
)

plotBamCoverage(
  fds,
  gr,
  sampleID,
  control_samples = sample(samples(fds[, which(samples(fds) != sampleID)]), min(3,
    ncol(fds) - length(sampleID))),
  txdb = NULL,
  min_junction_count = 20,
  highlight_range = NULL,
  highlight_range_color = "firebrick",
  color_annotated = "gray",
  color_novel = "goldenrod3",
  color_sample_interest = "firebrick",
  color_control_samples = "dodgerblue4",
  toscale = c("exon", "gene", "none"),
  mar = c(2, 10, 0.1, 5),
  curvature_splicegraph = 1,
  curvature_coverage = 1,
  cex = 1,
  splicegraph_labels = c("genomic_range", "id", "name", "none"),
  splicegraph_position = c("top", "bottom"),
  ...
)

plotBamCoverageFromResultTable(
  fds,
  result,
  show_full_gene = FALSE,
  txdb = NULL,
  orgDb = NULL,
  res_gene_col = "hgncSymbol",
  res_geneid_type = "SYMBOL",
  txdb_geneid_type = "ENTREZID",
  left_extension = 1000,
  right_extension = 1000,
  ...
)

\S4method{plotManhattan}{FraserDataSet}(
  object,
  sampleID,
  value = "pvalue",
  type = fitMetrics(object),
  chr = NULL,
  main = paste0("sample: ", sampleID),
  chrColor = c("black", "darkgrey"),
  subsetName = NULL,
  ...
)
}
\arguments{
\item{object, fds}{An \code{\link{FraserDataSet}} object.}

\item{...}{Additional parameters passed to plot() or plot_ly() if not stated
otherwise in the details for each plot function}

\item{sampleID}{A sample ID which should be plotted. Can also be a vector.
Integers are treated as indices.}

\item{type}{The psi type: either psi5, psi3 or theta (for SE).}

\item{basePlot}{if \code{TRUE} (default), use the R base plot version, else
use the plotly framework.}

\item{aggregate}{If TRUE, the pvalues are aggregated by gene (default), 
otherwise junction level pvalues are used (default for Q-Q plot).}

\item{main}{Title for the plot, if missing a default title will be used.}

\item{label}{Indicates the genes or samples that will be labelled in the 
plot (only for \code{basePlot=TRUE}). Setting 
\code{label="aberrant"} will label all aberrant genes or 
samples. Labelling can be turned off by setting 
\code{label=NULL}. The user can also provide a custom 
list of gene symbols or sampleIDs.}

\item{padjCutoff, deltaPsiCutoff}{Significance or delta
psi cutoff to mark outliers}

\item{subsetName}{The name of a subset of genes of interest for which FDR 
corrected pvalues were previously computed. Those FDR values 
on the subset will then be used to determine aberrant status. 
Default is NULL (using transcriptome-wide FDR corrected pvalues).}

\item{BPPARAM}{BiocParallel parameter to use.}

\item{idx}{A junction site ID or gene ID or one of both, which
should be plotted. Can also be a vector. Integers are treated
as indices.}

\item{result}{The result table to be used by the method.}

\item{colGroup}{Group of samples that should be colored.}

\item{global}{Flag to plot a global Q-Q plot, default FALSE}

\item{conf.alpha}{If set, a confidence interval is plotted, defaults to 0.05}

\item{samplingPrecision}{Plot only non overlapping points in Q-Q plot to 
reduce number of points to plot. Defines the digits to round to.}

\item{Ncpus}{Number of cores to use.}

\item{plotType}{The type of plot that should be shown as character string. 
For plotEncDimSearch, it has to be either \code{"sv"} for a plot
of the singular values against their rank, \code{"auc"} 
for a plot of the area under the curve (AUC) or 
\code{"loss"} for the model loss. For the correlation heatmap,
it can be either \code{"sampleCorrelation"} for a
sample-sample correlation heatmap or \code{"junctionSample"}
for a junction-sample correlation heatmap.}

\item{bins}{Set the number of bins to be used in the histogram.}

\item{legend.position}{Set legend position (x and y coordinate), defaults to
the top right corner.}

\item{onlyVariableIntrons}{Logical value indicating whether to show only 
introns that also pass the variability filter. Defaults to 
FALSE.}

\item{onlyExpressedIntrons}{Logical value indicating whether to show only 
introns that also pass the expression filter. Defaults to 
FALSE.}

\item{logit}{If TRUE, the default, psi values are plotted in logit space.}

\item{topN}{Top x most variable junctions that should be used for the
calculation of sample x sample correlations.}

\item{topJ}{Top x most variable junctions that should be displayed in the
junction-sample correlation heatmap. Only applies if plotType 
is "junctionSample".}

\item{minMedian, minCount, minDeltaPsi}{Minimal median (\eqn{m \ge 1}), 
delta psi (\eqn{|\Delta\psi| > 0.1}), read count (\eqn{n \ge 10})
value of a junction to be considered for the correlation heatmap.}

\item{normalized}{If TRUE, the normalized psi values are used, the default,
otherwise the raw psi values}

\item{show_rownames, show_colnames}{Logical value indicating whether to show
row or column names on the heatmap axes.}

\item{annotation_col, annotation_row}{Row or column annotations that should be
plotted on the heatmap.}

\item{border_color}{Sets the border color of the heatmap}

\item{nClust}{Number of clusters to show in the row and
column dendrograms.}

\item{sampleClustering}{A clustering of the samples that should be used as an
annotation of the heatmap.}

\item{plotMeanPsi, plotCov}{If \code{TRUE}, then the heatmap is annotated with
the mean psi values or the junction coverage.}

\item{gr}{A GRanges object indicating the genomic range that should be shown 
in \code{plotBamCoverage}.}

\item{control_samples}{The sampleIDs of the samples used as control in
\code{plotBamCoverage}.}

\item{txdb}{A TxDb object giving the gene/transcript annotation to use.}

\item{min_junction_count}{The minimal junction count across samples required 
for a junction to appear in the splicegraph and coverage tracks 
of \code{plotBamCoverage}.}

\item{highlight_range}{A \code{GenomicRanges} or \code{GenomicRangesList} 
object of ranges to be highlighted in the splicegraph of 
\code{plotBamCoverage}.}

\item{highlight_range_color}{The color of highlighted ranges in 
the splicegraph of \code{plotBamCoverage}.}

\item{color_annotated}{The color for exons and junctions present in 
the given annotation (in the splicegraph of 
\code{plotBamCoverage}).}

\item{color_novel}{The color for novel exons and junctions not present in 
the given annotation (in the splicegraph of 
\code{plotBamCoverage}).}

\item{color_sample_interest}{The color in \code{plotBamCoverage} for the 
sample of interest.}

\item{color_control_samples}{The color in \code{plotBamCoverage} for the 
samples used as controls.}

\item{toscale}{In \code{plotBamCoverage}, indicates which part of the 
plotted region should be drawn to scale. Possible values are 
'exon' (exonic regions are drawn to scale), 
'gene' (both exonic and intronic regions are drawn to scale) or 
'none' (exonic and intronic regions have constant length) 
(see SGSeq package).}

\item{mar}{The margin of the plot area for \code{plotBamCoverage} 
(b,l,t,r).}

\item{curvature_splicegraph}{The curvature of the junction arcs in the 
splicegraph in \code{plotBamCoverage}. Decrease this value 
for flatter arcs and increase it for steeper arcs.}

\item{curvature_coverage}{The curvature of the junction arcs in the 
coverage tracks of \code{plotBamCoverage}. Decrease this 
value for flatter arcs and increase it for steeper arcs.}

\item{cex}{For controlling the size of text and numbers in 
\code{plotBamCoverage}.}

\item{splicegraph_labels}{Indicated the format of exon/splice junction 
labels in the splicegraph of \code{plotBamCoverage}. 
Possible values are 'genomic_range' (gives the start position 
of the first exon and the end position of the last exon that 
are shown),  'id' (format E1,... J1,...), 'name' (format 
type:chromosome:start-end:strand for each feature), 
'none' for no labels (see SGSeq package).}

\item{splicegraph_position}{The position of the splicegraph relative to the 
coverage tracks in \code{plotBamCoverage}. Possible values 
are 'top' (default) and 'bottom'.}

\item{show_full_gene}{Should the full genomic range of the gene be shown in 
\code{plotBamCoverageFromResultTable} (default: FALSE)? 
If FALSE, only a certain region (see parameters left_extension 
and right_extension) around the outlier junction is shown.}

\item{orgDb}{A OrgDb object giving the mapping of gene ids and symbols.}

\item{res_gene_col}{The column name in the given results table that 
contains the gene annotation.}

\item{res_geneid_type}{The type of gene annotation in the results table in 
\code{res_gene_col} (e.g. SYMBOL or ENTREZID etc.). This 
information is needed for mapping between the results table and 
the provided annotation in the txdb object.}

\item{txdb_geneid_type}{The type of gene_id present in \code{genes(txdb)} 
(e.g. ENTREZID). This information is needed for 
mapping between the results table and the provided annotation 
in the txdb object.}

\item{left_extension}{Indicating how far the plotted range around the outlier 
junction should be extended to the left in 
\code{plotBamCoverageFromResultTable}.}

\item{right_extension}{Indicating how far the plotted range around the 
outlier junction should be extended to the right in 
\code{plotBamCoverageFromResultTable}.}

\item{value}{Indicates which assay is shown in the manhattan plot. Defaults 
to 'pvalue'. Other options are 'deltaPsi' and 'zScore'.}

\item{chr}{Vector of chromosome names to show in \code{plotManhattan}. The 
default is to show all chromosomes.}

\item{chrColor}{Interchanging colors by chromosome for \code{plotManhattan}.}
}
\value{
If base R graphics are used nothing is returned else the plotly or
            the gplot object is returned.
}
\description{
The FRASER package provides mutliple functions to visualize
the data and the results of a full data set analysis.

Plots the p values over the delta psi values, known as volcano plot.
Visualizes per sample the outliers. By type and aggregate by
gene if requested.

Plot the number of aberrant events per samples

Plots the observed split reads of the junction of interest over all reads
coming from the given donor/acceptor.

Plots the observed values of the splice metric across samples for a 
junction of interest.

Plots the expected psi value over the observed psi value of the given
junction.

Plots the quantile-quantile plot

Histogram of the geometric mean per junction based on the filter status

Histogram of minimal delta psi per junction

Count correlation heatmap function
}
\details{
This is the list of all plotting function provided by FRASER:
\itemize{
  \item plotAberrantPerSample()
  \item plotVolcano()
  \item plotExpression()
  \item plotQQ()
  \item plotExpectedVsObservedPsi()
  \item plotCountCorHeatmap()
  \item plotFilterExpression()
  \item plotFilterVariability()
  \item plotEncDimSearch()
  \item plotBamCoverage()
  \item plotBamCoverageFromResultTable()
  \item plotManhattan()
  \item plotSpliceMetricRank()
}

For a detailed description of each plot function please see the details.
Most of the functions share the same parameters.



\code{plotAberrantPerSample}: The number of aberrant events per sample are
plotted sorted by rank. The ... parameters are passed on to the
\code{\link{aberrant}} function.

\code{plotVolcano}: the volcano plot is sample-centric. It plots for a given
sample and psi type the negative log10 nominal P-values against the delta psi
values for all splice sites or aggregates by gene if requested.

\code{plotExpression}: This function plots for a given site the
read count at this site (i.e. K) against the total coverage (i.e. N) for the
given psi type (\eqn{\psi_5, \psi_3, or \theta}{\psi5, \psi3, or \theta}
(SE)) for all samples.

\code{plotQQ}: the quantile-quantile plot for a given gene or if
\code{global} is set to \code{TRUE} over the full data set. Here the
observed P-values are plotted against the expected ones in the negative
log10 space.

\code{plotExpectedVsObservedPsi}: A scatter plot of the observed psi
against the predicted psi for a given site.

\code{plotSpliceMetricRank}: This function plots for a given intron the
observed values of the selected splice metrix against the sample rank.

\code{plotCountCorHeatmap}: The correlation heatmap of the count data either
of the full data set (i.e. sample-sample correlations) or of the top x most
variable junctions (i.e. junction-sample correlations). By default the values
are log transformed and row centered. The ... arguments are passed to the
\code{\link[pheatmap]{pheatmap}} function.

\code{plotFilterExpression}: The distribution of FPKM values. If the 
FraserDataSet object contains the \code{passedFilter} column, it will plot 
both FPKM distributions for the expressed introns and for the filtered 
introns.

\code{plotFilterVariability}: The distribution of maximal delta Psi values. 
If the FraserDataSet object contains the \code{passedFilter} column, 
it will plot both maximal delta Psi distributions for the variable 
introns and for the filtered (i.e. non-variable) introns.

\code{plotEncDimSearch}: Visualization of the hyperparameter optimization.
It plots the encoding dimension against the achieved loss (area under the
precision-recall curve). From this plot the optimum should be choosen for
the \code{q} in fitting process.

\code{plotManhattan}: A Manhattan plot showing the junction pvalues by 
genomic position. Useful to identify if outliers cluster by genomic position.

\code{plotBamCoverage}: A sashimi plot showing the read coverage from 
the underlying bam files for a given genomic range and sampleIDs. 

\code{plotBamCoverageFromResultTable}: A sashimi plot showing the read 
coverage from the underlying bam files for a row in the results table. Can 
either show the full range of the gene with the outlier junction or only a 
certain region around the outlier.
}
\examples{
\dontshow{set.seed(42)}
# create full FRASER object 
fds <- makeSimulatedFraserDataSet(m=40, j=200)
fds <- calculatePSIValues(fds)
fds <- filterExpressionAndVariability(fds, filter=FALSE)
# this step should be done for more dimensions in practice
fds <- estimateBestQ(fds, type="jaccard", useOHT=FALSE, q_param=c(2,5,10,25))

# assign gene names to show functionality on test dataset
# use fds <- annotateRanges(fds) on real data
mcols(fds, type="j")$hgnc_symbol <- 
    paste0("gene", sample(1:25, nrow(fds), replace=TRUE))

# fit and calculate pvalues
genesOfInterest <- rep(list(paste0("gene", sample(1:25, 10))), 4)
names(genesOfInterest) <- c("sample1", "sample6", "sample15", "sample23")
fds <- FRASER(fds, subsets=list("testSet"=genesOfInterest))

# QC plotting
plotFilterExpression(fds)
plotFilterVariability(fds)
plotCountCorHeatmap(fds, "jaccard")
plotCountCorHeatmap(fds, "jaccard", normalized=TRUE)
plotEncDimSearch(fds, type="jaccard")

# extract results 
plotAberrantPerSample(fds, aggregate=FALSE)
plotAberrantPerSample(fds, aggregate=TRUE, subsetName="testSet")
plotVolcano(fds, "sample2", "jaccard", label="aberrant")
plotVolcano(fds, "sample1", "jaccard", aggregate=TRUE, subsetName="testSet")

# dive into gene/sample level results
res <- data.table::as.data.table(results(fds))
res
plotExpression(fds, result=res[1])
plotQQ(fds, result=res[1])
plotExpectedVsObservedPsi(fds, res=res[1])
plotSpliceMetricRank(fds, res=res[1])

# other ways to call these plotting functions
plotExpression(fds, idx=10, sampleID="sample1", type="jaccard")
plotExpression(fds, result=res[1], subsetName="testSet")
plotQQ(fds, idx=10, sampleID="sample1", type="jaccard")
plotQQ(fds, result=res[1], subsetName="testSet")
plotExpectedVsObservedPsi(fds, idx=10, sampleID="sample1", type="jaccard")
plotExpectedVsObservedPsi(fds, result=res[1], subsetName="testSet")
plotSpliceMetricRank(fds, idx=10, sampleID="sample1", type="jaccard")
plotSpliceMetricRank(fds, result=res[1], subsetName="testSet")

# create manhattan plot of pvalues by genomic position
if(require(ggbio)){
    plotManhattan(fds, type="jaccard", sampleID="sample10")
}

# plot splice graph and coverage from bam files in a given region
if(require(SGSeq)){
    fds <- createTestFraserSettings()
    gr <- GRanges(seqnames="chr19", 
        IRanges(start=7587496, end=7598895), 
        strand="+")
    plotBamCoverage(fds, gr=gr, sampleID="sample3", 
        control_samples="sample2", min_junction_count=5,
        curvature_splicegraph=1, curvature_coverage=1, 
        mar=c(1, 7, 0.1, 3))

    # plot coverage from bam file for a row in the result table
    fds <- createTestFraserDataSet()
    require(TxDb.Hsapiens.UCSC.hg19.knownGene)
    txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
    require(org.Hs.eg.db)
    orgDb <- org.Hs.eg.db
 
    res <- results(fds, padjCutoff=NA, deltaPsiCutoff=NA)
    res_dt <- data.table::as.data.table(res)
    res_dt <- res_dt[sampleID == "sample2",]
    
    # plot full range of gene containing outlier junction
    plotBamCoverageFromResultTable(fds, result=res_dt[1,], show_full_gene=TRUE,
        txdb=txdb, orgDb=orgDb, control_samples="sample3")
    
    # plot only certain range around outlier junction
    plotBamCoverageFromResultTable(fds, result=res_dt[1,], show_full_gene=FALSE, 
        control_samples="sample3", curvature_splicegraph=0.5, txdb=txdb,
        curvature_coverage=0.5, right_extension=5000, left_extension=5000,
        splicegraph_labels="id")
}

}
