% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_filter.R
\name{length_filter}
\alias{length_filter}
\title{Filter sequences of a FASTQ file by length}
\usage{
length_filter(input, rm.min = NA, rm.max = NA)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}

\item{rm.min}{Threshold value for the minimun number of bases}

\item{rm.max}{Threshold value for the  maximum number of bases}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} 
object
}
\description{
The program removes from a ShortReadQ object those sequences
with a length lower than rm.min or/and higher than rm.max
}
\examples{
require('Biostrings')
require('ShortRead')

# create  ShortReadQ object width widths between 1 and 100
 
 set.seed(10)
input <- random_length(100, widths = 1:100)

# apply the filter, removing sequences length < 10 or length > 80
filtered <- length_filter(input, rm.min = 10, rm.max = 80)

# look at the filtered sequences
sread(filtered)
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
