% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmean_filter.R
\name{qmean_filter}
\alias{qmean_filter}
\title{Filter sequences by their average quality}
\usage{
qmean_filter(input, minq, q_format = NULL, check.encod = TRUE)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}

\item{minq}{Quality threshold}

\item{q_format}{Quality format used for the file, as returned 
by check.encoding}

\item{check.encod}{Check the encoding of the sequence? This argument 
is incompatible with q_format}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} 
object
}
\description{
The program removes the sequences with a quality 
lower the 'minq' threshold
}
\examples{

require(ShortRead)

set.seed(10)
# create 30 sequences of width 20
input <- random_seq(30, 20)

# create qualities of width 20 
## high quality (15 sequences)
set.seed(10)
my_qual <- random_qual(c(30,40), slength = 15, swidth = 20,
                       encod = 'Sanger')
## low quality (15 sequences)
set.seed(10)
my_qual_2 <-   random_qual(c(5,30), slength = 15, swidth = 20,
                           encod = 'Sanger')

# concatenate vectors
input_q<- c(my_qual, my_qual_2)

# create names
input_names <- seq_names(30)

# create ShortReadQ object
my_read <- ShortReadQ(sread = input, quality = input_q, id = input_names)

# watch the average qualities
alphabetScore(my_read) / width(my_read)

# apply the filter
filtered <- qmean_filter(my_read, minq = 30)

# watch the average qualities
alphabetScore(my_read) / width(my_read)


# watch the filtered sequences
sread(filtered)

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
