% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_FlowSOM.R
\name{FlowSOM}
\alias{FlowSOM}
\title{Run the FlowSOM algorithm}
\usage{
FlowSOM(
  input,
  pattern = ".fcs",
  compensate = FALSE,
  spillover = NULL,
  transform = FALSE,
  toTransform = NULL,
  transformFunction = flowCore::logicleTransform(),
  transformList = NULL,
  scale = FALSE,
  scaled.center = TRUE,
  scaled.scale = TRUE,
  silent = TRUE,
  colsToUse = NULL,
  nClus = 10,
  maxMeta = NULL,
  importance = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{input}{a flowFrame, a flowSet, a matrix with column names or
an array of paths to files or directories}

\item{pattern}{if input is an array of file- or directorynames, select 
only files containing pattern}

\item{compensate}{logical, does the data need to be compensated}

\item{spillover}{spillover matrix to compensate with
If NULL and compensate = TRUE, we will look for $SPILL 
description in FCS file.}

\item{transform}{logical, does the data need to be transformed with the
transformation given in \code{transformFunction}.}

\item{toTransform}{column names or indices that need to be transformed.
Will be ignored if \code{transformList} is given.
If \code{NULL} and transform = \code{TRUE}, column names
of \code{$SPILL} description in FCS file will be used.}

\item{transformFunction}{Defaults to logicleTransform()}

\item{transformList}{transformList to apply on the samples.}

\item{scale}{logical, does the data needs to be rescaled. 
Default = FALSE}

\item{scaled.center}{see \code{\link{scale}}}

\item{scaled.scale}{see \code{\link{scale}}}

\item{silent}{if \code{TRUE}, no progress updates will be printed}

\item{colsToUse}{Markers, channels or indices to use for building the SOM. 
Default (NULL) is all the columns used to build the 
FlowSOM object.}

\item{nClus}{Exact number of clusters for meta-clustering. 
Ignored if maxMeta is specified.
Default = 10.}

\item{maxMeta}{Maximum number of clusters to try out for 
meta-clustering. If \code{NULL} (default), only one 
option will be computed (\code{nClus}).}

\item{importance}{array with numeric values. Parameters will be scaled 
according to importance}

\item{seed}{Set a seed for reproducible results}

\item{...}{options to pass on to the SOM function 
(xdim, ydim, rlen, mst, alpha, radius, init, distf)}
}
\value{
A \code{list} with two items: the first is the flowSOM object 
        containing all information (see the vignette for more detailed 
        information about this object), the second is the metaclustering of 
        the nodes of the grid. This is a wrapper function for 
        \code{\link{ReadInput}}, \code{\link{BuildSOM}}, 
        \code{\link{BuildMST}} and \code{\link{MetaClustering}}. 
        Executing them separately may provide more options.
}
\description{
Method to run general FlowSOM workflow. 
Will scale the data and uses consensus meta-clustering by default.
}
\examples{
# Read from file
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9, 12, 14:18), nClus = 10)
# Or read from flowFrame object
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
flowSOM.res <- FlowSOM(ff, 
                       scale = TRUE, 
                       colsToUse = c(9, 12, 14:18), 
                       nClus = 10)

# Plot results
PlotStars(flowSOM.res,
          backgroundValues = flowSOM.res$metaclustering)

# Get metaclustering per cell
flowSOM.clustering <- GetMetaclusters(flowSOM.res)

}
\seealso{
\code{\link{scale}}, 
         \code{\link{ReadInput}}, 
         \code{\link{BuildSOM}},
         \code{\link{BuildMST}}, 
         \code{\link{MetaClustering}}
}
