% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotDimRed}
\alias{PlotDimRed}
\title{PlotDimRed}
\usage{
PlotDimRed(
  fsom,
  colsToUse = fsom$map$colsUsed,
  colorBy = "metaclusters",
  colors = NULL,
  lim = NULL,
  cTotal = NULL,
  dimred = Rtsne::Rtsne,
  extractLayout = function(dimred) {
     dimred$Y
 },
  label = TRUE,
  returnLayout = FALSE,
  seed = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{colsToUse}{The columns used for the dimensionality reduction. 
Default = fsom$map$colsUsed.}

\item{colorBy}{Defines how the dimensionality reduction will be 
colored. Can be "metaclusters" (default), "clusters" 
(or abbreviations) or a marker/channel/index.}

\item{colors}{A vector of custom colors. Default returns ggplot
colors for categorical variables and the FlowSOM colors
for continuous variables. When using a categorical 
variable, the vector must be as long as
the levels of the categorical variable.}

\item{lim}{Limits for the colorscale}

\item{cTotal}{The total amount of cells to be used in the 
dimensionality reduction. Default is all the cells.}

\item{dimred}{A dimensionality reduction function. 
Default = Rtsne::Rtsne. Alternatively, a data.frame or
matrix with either equal number of rows to the
fsom or an OriginalID column. Recommended to put
cTotal to NULL when providing a matrix (or ensuring
that the dimred corresponds to subsampling the
flowSOM data for cTotal cells with the same seed).}

\item{extractLayout}{A function to extract the coordinates from the results
of the dimred default = function(dimred){dimred$Y}.}

\item{label}{If label = TRUE (default), labels are added to plot.}

\item{returnLayout}{If TRUE, this function returns a dataframe with 
the layout of dimred and the original IDs and the 
plot. Default = FALSE.}

\item{seed}{A seed for reproducibility.}

\item{title}{A title for the plot.}

\item{...}{Additional arguments to pass to dimred.}
}
\value{
A dimensionality reduction plot made in ggplot2
}
\description{
Plot a dimensionality reduction
}
\details{
Plot a dimensionality reduction of fsom$data
}
\examples{
   file <- system.file("extdata", "68983.fcs", package="FlowSOM")
   flowSOM.res <- FlowSOM(file, compensate = TRUE, transform = TRUE, 
                  scale = TRUE,
                  colsToUse = c(9, 12, 14:18), nClus = 10, silent = FALSE,
                  xdim = 7, ydim = 7)
   PlotDimRed(flowSOM.res, cTotal = 5000, seed = 1, title = "t-SNE")
   PlotDimRed(flowSOM.res, cTotal = 5000, colorBy = "CD3", seed = 1, 
              title = "t-SNE")
   
}
