% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{UpdateNodeSize}
\alias{UpdateNodeSize}
\title{UpdateNodeSize}
\usage{
UpdateNodeSize(
  fsom,
  count = NULL,
  reset = FALSE,
  transform = sqrt,
  maxNodeSize = 15,
  shift = 0,
  scale = NULL
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{count}{Absolute cell count of the sample}

\item{reset}{Logical. If \code{TRUE}, all nodes get the same size}

\item{transform}{Transformation function. Use e.g. square root to let counts
correspond with area of node instead of radius}

\item{maxNodeSize}{Maximum node size after rescaling. Default: 15}

\item{shift}{Shift of the counts, defaults to 0}

\item{scale}{Scaling of the counts, defaults to the maximum of the value
minus the shift. With shift and scale set as default, the 
largest node will be maxNodeSize and an empty node will have
size 0}
}
\value{
Updated FlowSOM object
}
\description{
Update nodesize of FlowSOM object
}
\details{
Add size property to the graph based on cellcount for each node
}
\examples{
# Read from file, build self-organizing map and minimal spanning tree
fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
flowSOM.res <- ReadInput(fileName, compensate=TRUE,transform=TRUE,
                        scale=TRUE)
flowSOM.res <- BuildSOM(flowSOM.res,colsToUse=c(9,12,14:18))
flowSOM.res <- BuildMST(flowSOM.res)

# Give all nodes same size
PlotStars(flowSOM.res, equalNodeSize = TRUE)

# Node sizes relative to amount of cells assigned to the node
PlotStars(flowSOM.res)

}
\seealso{
\code{\link{BuildMST}}
}
