% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{optiPlot}
\alias{optiPlot}
\title{Generate elbow plots}
\usage{
optiPlot(data, method = "jump")
}
\arguments{
\item{data}{a Self Organizing Map object generated by generatePrototypes(),
or an object of class SingleCellExperiment or SpatialExperiment}

\item{method}{one of 'jump', 'slope', 'wcd', 'gap', or 'silhouette'}
}
\value{
an elbow plot object where the optimal number of clusters is marked
}
\description{
A function generating the elbow plot for the optimal number of clusters
returned by the estimateNumcluster() function
Methods available are:
Gap, Silhouette, Slope, Jump, and Within Cluster Distance(WCD)
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
res <- runFuseSOM(risom_dat, markers = risomMarkers, numClusters = 23)
resEstK <- estimateNumCluster(res$model, kSeq = 2:25)
p <- optiPlot(resEstK, method = "jump")

}
\author{
Elijah WIllie \href{mailto:ewil3501@uni.sydney.edu.au}{ewil3501@uni.sydney.edu.au}
}
