% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBiosample.R
\name{getBiosample}
\alias{getBiosample}
\title{getBiosample function}
\usage{
getBiosample(host, biosampleId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{biosampleId}{ID of the biosample requested.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a biosample by its ID.
}
\details{
This function requests \code{GET host/datasets/biosampleId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
biosampleId <- searchBiosamples(host, datasetId, nrows = 1)$id
getBiosample(host, biosampleId)
}
}
\references{
\href{http://ga4gh-schemas.readthedocs.io/en/latest/schemas/bio_metadata_service.proto.html#GetBiosample}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchBiosamples}}
}
