% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRnaQuantification.R
\name{getRnaQuantification}
\alias{getRnaQuantification}
\title{getRnaQuantification function}
\usage{
getRnaQuantification(host, rnaQuantificationId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{rnaQuantificationId}{ID of the RNA quantification requested.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get an RNA quantification by its ID.
}
\details{
This function requests \code{GET host/rnaquantifications/rnaQuantificationId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
rnaQuantificationSetId <- searchRnaQuantificationSets(host, datasetId, nrows = 1)$id
rnaQuantificationId <- searchRnaQuantifications(host, rnaQuantificationSetId, nrows = 1)$id
getRnaQuantification(host, rnaQuantificationId)
}
}
\references{
\href{http://ga4gh-schemas.readthedocs.io/en/latest/schemas/rna_quantification_service.proto.html#GetRnaQuantification}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchRnaQuantifications}}
}
