% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeVCFFromGA4GHResponse.R
\name{makeVCFFromGA4GHResponse}
\alias{makeVCFFromGA4GHResponse}
\title{makeVCFFromGA4GHResponse function}
\usage{
makeVCFFromGA4GHResponse(variants)
}
\arguments{
\item{variants}{\code{DataFrame} generated by \code{\link{searchVariants}}.}
}
\value{
\code{\link{VCF}} object.
}
\description{
Convert \code{DataFrame} output from
\code{\link{searchVariants}} and \code{\link{getVariant}} functions to
\code{\link{VCF}} class.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
variants <- searchVariants(host, variantSetId, referenceName = "1",
    start = 15000, end = 16000)
variants

makeVCFFromGA4GHResponse(variants)
}
}
\seealso{
\code{\link{searchVariants}}, \code{\link{getVariant}},
\code{\link{VCF}}, \code{\link{DataFrame}}
}
