% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GbsrScheme-class}
\alias{GbsrScheme-class}
\alias{GbsrScheme}
\title{Class \code{GbsrScheme}}
\description{
\link{GBScleanR} uses breeding scheme information to set the expected
number of cross overs in a chromosome which is a required parameter
for the genotype error correction with the hidden Markov model
implemented in the \code{\link[=estGeno]{estGeno()}} function. This class stores those
information including ID of parental samples, type crosses
performed at each generation of breeding and population
sizes of each generation. This class is not exported.
}
\section{Slots}{

\describe{
\item{\code{crosstype}}{A vector of strings indicating the type of
crossing done at each generation.}

\item{\code{mating}}{A list of matrices showing combinations member
IDs of samples mated.}

\item{\code{parents}}{A vector of member IDs of parents.}

\item{\code{progenies}}{A vector of memeber IDs of progenies produced
at each generation.}

\item{\code{samples}}{A vector of member IDs of samples indicating which samples are
derived from which pedigrees.}
}}

\examples{
# [loadGDS()] initialize a `GbsrScheme` object internally and
# attache it to the shceme slot of a [GbsrGenotypeData] object.

# Load data in the GDS file and instantiate
# a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Print the information stored in the `GbsrScheme` object.
showScheme(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
\seealso{
\link{GbsrGenotypeData} dnd \code{\link[=loadGDS]{loadGDS()}}.
}
