% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{gbsrGDS2VCF}
\alias{gbsrGDS2VCF}
\alias{gbsrGDS2VCF,GbsrGenotypeData-method}
\title{Write a VCF file based on data in a GDS file}
\usage{
gbsrGDS2VCF(
  object,
  out_fn,
  node = "raw",
  info.export = NULL,
  fmt.export = NULL,
  parents = TRUE,
  ...
)

\S4method{gbsrGDS2VCF}{GbsrGenotypeData}(object, out_fn, node, info.export, fmt.export, parents)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{out_fn}{A string to specify the path to an output VCF file.}

\item{node}{Either one of "raw" or "cor" to output raw genotype data or
corrected genotype data, respectively.}

\item{info.export}{characters, the variable name(s) in the INFO node for
export; or NULL for all variables. If you specify \code{character(0)}, nothing
will be exported from the INFO node.}

\item{fmt.export}{characters, the variable name(s) in the FORMAT node for
import; or NULL for all variables. If you specify \code{character(0)}, nothing
will be exported from the FORMAT node, except for GT.}

\item{parents}{A logical value to specify whether parental
samples should be included in an output VCF file or not.}

\item{...}{Unused.}
}
\value{
The path to the VCF file.
}
\description{
Write out a VCF file with raw, filtered, or corrected genotype data
stored in a GDS file. The output VCF file contains the GT, AD, and DP fields.
}
\details{
Create a VCF file at location specified by out_fn.
The connection to the GDS file of the input \link{GbsrGenotypeData} object will be
automatically closed for internal file handling in this function. Please use
\code{\link[=reopenGDS]{reopenGDS()}} to open the connection again. If you use \code{\link[=loadGDS]{loadGDS()}}, summary
statistics and filtering information will be discarded.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Create a VCF file with data from the GDS file
#  connected to the [GbsrGenotypeData] oobject.
out_fn <- tempfile("sample_out", fileext = ".vcf.gz")
# gbsrGDS2VCF(gds, out_fn)

# Close the connection to the GDS file.
closeGDS(gds)

}
