% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getHaplotype}
\alias{getHaplotype}
\alias{getHaplotype,GbsrGenotypeData-method}
\title{Get haplotype call data.}
\usage{
getHaplotype(object, parents = FALSE, valid = TRUE, chr = NULL, ...)

\S4method{getHaplotype}{GbsrGenotypeData}(object, parents, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{parents}{A logical value or "only" to include data for
parents or to get data only for parents.}

\item{valid}{A logical value. See details.}

\item{chr}{A integer vector of indexes indicating chromosomes
to get read count data.}

\item{...}{Unused.}
}
\value{
An integer array of haplotype data. The array have 2 x M x N
dimensions, where M is the number of markers and N is the number of
samples. Each integer values represent the origin of the haplotype.
For example, in the population with two inbred founders, values take
either 1 or 2 indicating the hapotype descent from founder 1 and 2.
If two outbred founders, values take 1, 2, 3, or 4 indicating
the first and second haplotype in founder 1 and the first and
second haplotype in founder 2.
}
\description{
Haplotype calls are retrieved from the GDS file linked to the given
\link{GbsrGenotypeData} object.
}
\details{
Haplotype call data can be obtained from the "estimated.haplotype" node of
the GDS file which can be generated via the \code{\link[=estGeno]{estGeno()}} function.
Thus, this function is valid only after having executed \code{\link[=estGeno]{estGeno()}}.
If \code{valid = TRUE}, read counts for only valid marker and valid samples will
be obtained.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Find the IDs of parental samples.
parents <- grep("Founder", getSamID(gds), value = TRUE)

# Set the parents and flip allele information
# if the reference sample (Founder1 in our case) has homozygous
# alternative genotype at some markers of which alleles will
# be swapped to make the reference sample have homozygous
# reference genotype.
gds <- setParents(gds, parents = parents)

# Initialize a scheme object stored in the slot of the GbsrGenotypeData.
# We chose `crosstype = "pair"` because two inbred founders were mated
# in our breeding scheme.
# We also need to specify the mating matrix which has two rows and
# one column with integers 1 and 2 indicating a sample (founder)
# with the memberID 1 and a sample (founder) with the memberID 2
# were mated.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Add information of the next cross conducted in our scheme.
# We chose 'crosstype = "selfing"', which do not require a
# mating matrix.
gds <- addScheme(gds, crosstype = "selfing")

# Execute error correction by estimating genotype and haplotype of
# founders and offspring.
gds <- estGeno(gds)

hap <- getHaplotype(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
\seealso{
\code{\link[=estGeno]{estGeno()}}
}
