% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{resetMarFilter}
\alias{resetMarFilter}
\alias{resetMarFilter,GbsrGenotypeData-method}
\title{Reset the filter made by \code{\link[=setMarFilter]{setMarFilter()}}}
\usage{
resetMarFilter(object, ...)

\S4method{resetMarFilter}{GbsrGenotypeData}(object)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object after removing all filters on markers.
}
\description{
Remove "invalid" labels put on markers and make all markers valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Check the number of markers.
nmar(gds)

# Summarize the information needed for filtering.
gds <- countGenotype(gds)
gds <- countRead(gds)

# filter out some markers meeting the criteria.
gds <- setMarFilter(gds,
                      id = getMarID(gds)[1:100],
                      missing = 0.2,
                      dp = c(5, Inf))

# Check the number of the retained markers.
nmar(gds)

# Reset all filters applied above.
gds <- resetMarFilter(gds)

# Check the number of the markers again.
nmar(gds)

# Close the connection to the GDS file.
closeGDS(gds)
}
