% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{resetSamFilter}
\alias{resetSamFilter}
\alias{resetSamFilter,GbsrGenotypeData-method}
\title{Reset the filter made by \code{\link[=setSamFilter]{setSamFilter()}}}
\usage{
resetSamFilter(object, ...)

\S4method{resetSamFilter}{GbsrGenotypeData}(object)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object after removing
all filters on samples.
}
\description{
Remove "invalid" labels put on samples and make all samples valid.
}
\examples{
# Create a GDS file from a sample VCF file.
vcf_fn <- system.file("extdata", "sample.vcf", package = "GBScleanR")
gds_fn <- tempfile("sample", fileext = ".gds")
gbsrVCF2GDS(vcf_fn = vcf_fn, out_fn = gds_fn, force = TRUE)

# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds <- loadGDS(gds_fn)

# Summarize the information needed for filtering.
gds <- countGenotype(gds)
gds <- countRead(gds)

gds <- setSamFilter(gds,
                       id = getSamID(gds)[1:10],
                       missing = 0.2,
                       dp = c(5, Inf))

# Reset all filters applied above.
gds <- resetSamFilter(gds)

# Close the connection to the GDS file
closeGDS(gds)

}
