% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{setInfoFilter}
\alias{setInfoFilter}
\alias{setInfoFilter,GbsrGenotypeData-method}
\title{Filter out markers based on marker quality metrics}
\usage{
setInfoFilter(
  object,
  mq = 0,
  fs = Inf,
  qd = 0,
  sor = Inf,
  mqranksum = c(-Inf, Inf),
  readposranksum = c(-Inf, Inf),
  baseqranksum = c(-Inf, Inf),
  ...
)

\S4method{setInfoFilter}{GbsrGenotypeData}(object, mq, fs, qd, sor, mqranksum, readposranksum, baseqranksum)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{mq}{A numeric value to specify minimum mapping
quality (shown as MQ in the VCF format).}

\item{fs}{A numeric value to specify maximum Phred-scaled
p-value (strand bias) (shown as FS in the VCF format).}

\item{qd}{A numeric value to specify minimum Variant
Quality by Depth (shown as QD in the VCF format).}

\item{sor}{A numeric value to specify maximum
Symmetric Odds Ratio (strand bias) (shown as SOR in the VCF format).}

\item{mqranksum}{A numeric values to specify the lower
and upper limit of Alt vs. Ref read mapping
qualities (shown as MQRankSum in the VCF format).}

\item{readposranksum}{A numeric values to specify the lower
and upper limit of Alt vs. Ref read position
bias (shown as ReadPosRankSum in the VCF format).}

\item{baseqranksum}{A numeric values to specify the lower
and upper limit of Alt Vs. Ref base
qualities (shown as BaseQRankSum in the VCF format).}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object with filters on markers.
}
\description{
A VCF file usually has marker quality metrics in
the INFO filed and those are stored in
a GDS file created via \link{GBScleanR}. This function filter
out markers based on those marker
quality metrics.
}
\details{
Detailed explanation of each metric can be found
in \href{https://gatk.broadinstitute.org/hc/en-us}{GATK's web site}.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

gds <- setInfoFilter(gds, mq = 40, qd = 20)

# Close the connection to the GDS file.
closeGDS(gds)
}
