% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R,
%   R/Methods-GbsrScheme.R
\name{showScheme}
\alias{showScheme}
\alias{showScheme,GbsrGenotypeData-method}
\alias{showScheme,GbsrScheme-method}
\title{Show the information stored in a \link{GbsrScheme} object}
\usage{
showScheme(object, ...)

\S4method{showScheme}{GbsrGenotypeData}(object)

\S4method{showScheme}{GbsrScheme}(object, parents_name, pedigree)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{...}{Unused.}

\item{parents_name}{A vector of strings to indicate names
of parental samples. This argument is used internally by showScheme()
for the gbsrGenotypeData object.}

\item{pedigree}{A integer vector indicating the member
ID assignment to samples. This argument is used internally by
showScheme() for the gbsrGenotypeData object.}
}
\value{
NULL. Print the scheme information on the R console.
}
\description{
Print the information of each generation in
a \link{GbsrScheme} object in the scheme
slot of a \link{GbsrGenotypeData} object.
A \link{GbsrScheme} object stores information of a population size,
mating combinations and
a type of cross applied to each generation of the breeding process
to generate the population which you are going to
subject to the \code{estGeno()} function.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Biparental F2 population.
gds <- setParents(gds, parents = c("Founder1", "Founder2"))

# setParents gave member ID 1 and 2 to Founder1 and Founder2, respectively.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Now the progenies of the cross above have member ID 3.
# If `crosstype = "selfing"` or `"sibling"`, you can omit a `mating` matrix.
gds <- addScheme(gds, crosstype = "self")

# Now you can execute `estGeno()` which requires a [GbsrScheme] object.

# Close the connection to the GDS file
closeGDS(gds)

}
\seealso{
\code{\link[=initScheme]{initScheme()}} and \code{\link[=addScheme]{addScheme()}}
}
