% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGEOSuppFiles.R
\name{getGEOSuppFiles}
\alias{getGEOSuppFiles}
\title{Get Supplemental Files from GEO}
\usage{
getGEOSuppFiles(
  GEO,
  makeDirectory = TRUE,
  baseDir = getwd(),
  fetch_files = TRUE,
  filter_regex = NULL
)
}
\arguments{
\item{GEO}{A GEO accession number such as GPL1073 or GSM1137}

\item{makeDirectory}{Should a 'subdirectory' for the downloaded files be
created?  Default is TRUE.  If FALSE, the files will be downloaded directly
into the baseDir.}

\item{baseDir}{The base directory for the downloads.  Default is the current
working directory.}

\item{fetch_files}{logical(1). If TRUE, then actually download the
files. If FALSE, just return the filenames that would have been
downloaded. Useful for testing and getting a list of files
without actual download.}

\item{filter_regex}{A character(1) regular expression that will be
used to filter the filenames from GEO to limit those files that
will be downloaded. This is useful to limit to, for example,
bed files only.}
}
\value{
If fetch_files=TRUE, a data frame is returned invisibly with rownames representing the
full path of the resulting downloaded files and the records in the
data.frame the output of file.info for each downloaded file.
If fetch_files=FALSE, a data.frame of URLs and filenames is returned.
}
\description{
NCBI GEO allows supplemental files to be attached to GEO Series (GSE), GEO
platforms (GPL), and GEO samples (GSM).  This function 'knows' how to get
these files based on the GEO accession.  No parsing of the downloaded files
is attempted, since the file format is not generally knowable by the
computer.
}
\details{
Again, just a note that the files are simply downloaded.
}
\examples{

a <- getGEOSuppFiles('GSM1137', fetch_files = FALSE)
a

# with a set of single-cell RNA-seq data
a <- getGEOSuppFiles('GSE161228', fetch_files = FALSE)
a

}
\author{
Sean Davis \href{mailto:sdavis2@mail.nih.gov}{sdavis2@mail.nih.gov}
}
\keyword{IO}
\keyword{database}
