% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{plot_tree}
\alias{plot_tree}
\title{Plot the regression tree.}
\usage{
plot_tree(gnet_result, group_idx)
}
\arguments{
\item{gnet_result}{Results returned by gnet().}

\item{group_idx}{Index of the module.}
}
\value{
None
}
\description{
Plot the regression tree given the index of a module.
}
\examples{
set.seed(1)
init_group_num = 5
init_method = 'boosting'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
plot_tree(gnet_result,group_idx=1)
}
