% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{filterConnectionsForPlotting}
\alias{filterConnectionsForPlotting}
\title{Filter connections for subsequent visualization with `visualizeGRN()` from the filtered eGRN}
\usage{
filterConnectionsForPlotting(GRN, plotAll = TRUE, ..., forceRerun = FALSE)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{plotAll}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}. Should all connections be included for plotting? 
If set to \code{TRUE}, all connections are marked for plotting and everything else is ignored. This resets any previous setting.
If set \code{FALSE}, the filter expressions (if any) are used to determine which connection to plot}

\item{...}{An arbitrary set of arguments that is used directly, without modification, as input for dplyr::filter and therefore has to be valid expression that dplyr::filter understands.
The filtering is based on the \code{all.filtered} table as stored in \code{GRN@connections$all.filtered$`0`}. Thus, the specific filters can be completely
arbitrary for ultimate flexibility and must only adhere to the column names and types as defined in \code{GRN@connections$all.filtered$`0`}. See the examples also for what you can do.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with added data from this function.
}
\description{
This helper function provides an easy and flexible way to retain particular connections for plotting and discard all others. Note that this filtering is only
relevant and applicable for the function `visualizeGRN()` and ignored anywhere else. This makes it possible to visualize only specific TF regulons or to plot only
connections that fulfill particular filter criteria. Due to the flexibility of the implementation by allowing arbitrary filters that are passed directly to
\code{dplyr::filter}, users can visually investigate the eGRN, which is particularly useful when the eGRNs is large and has many connections.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = filterConnectionsForPlotting (GRN, plotAll = FALSE, TF.ID == "E2F6.0.A")
GRN = filterConnectionsForPlotting (GRN, plotAll = FALSE, TF_peak.r > 0.7 | TF_peak.fdr < 0.2)
GRN = filterConnectionsForPlotting (GRN, plotAll = FALSE, TF_peak.r > 0.7, TF_peak.fdr < 0.2)
}
