% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{getGRNSummary}
\alias{getGRNSummary}
\title{Summarize a \code{\linkS4class{GRN}} object to a named list for comparison with other \code{\linkS4class{GRN}} objects.}
\usage{
getGRNSummary(GRN, silent = FALSE)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{silent}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Should the function be silent and print nothing?}
}
\value{
A named list summarizing the GRN object. This function does **NOT** return a \code{\linkS4class{GRN}} object, but instead a named lsit with the
following elements: 
\itemize{
\item \code{data}:
 \itemize{
 \item \code{peaks}, \code{genes} and \code{TFs}: 
 \item \code{sharedSamples}: 
 \item \code{metadata}: 
 }
\item \code{parameters} and \code{config}: GRN parameters and config information
 \item \code{connections}: Connection summary for different connection types
 \itemize{
 \item \code{TF_peak}: TF-peak  (number of connections for different FDR thresholds)
 \item \code{peak_genes}: Peak-gene 
 \item \code{TF_peak_gene}: TF-peak-gene
 }      
 \item \code{network}: Network-related summary, including the number of nodes, edges, communities and enrichment for both the TF-peak-gene and TF-gene network
 \itemize{
 \item \code{TF_gene}
 \item \code{TF_peak_gene}
 }
}
}
\description{
\strong{Note: This function, as all \code{get} functions from this package, does NOT return a \code{\linkS4class{GRN}} object.}
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
summary.l = getGRNSummary(GRN)
}
