% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRaccessors.R
\name{GRgetDefs}
\alias{GRgetDefs}
\title{GR metrics definitions}
\usage{
GRgetDefs(fitData)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}
}
\value{
A table of definitions of GR metrics and traditional metrics
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table with the definition of each GR metric and 
traditional metric that is calculated.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table containing the definition of each GR metric,
traditional metric, and goodness of fit measure in the object. 
This is simply a convenient accessor function, equivalent to 
\code{rowData(fitData)}.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent'))
defs = GRgetDefs(output1)
# See all definitions (some will be truncated)
\dontrun{View(defs)}
# See the first six descriptions
head(defs)
# Look at a specific definition
defs[15,]
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}.
}
\author{
Nicholas Clark
}
